/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvableToSingleWithRelationships;
import org.hawkular.inventory.api.TransactionFrame;
import org.hawkular.inventory.api.WriteInterface;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.ElementTypeVisitor;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.RestBulk;

/*
 * Exception performing whole class analysis ignored.
 */
@Path(value="/bulk")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/bulk", description="Endpoint for bulk operations on inventory entities", tags={"Bulk Create"})
public class RestBulk
extends RestBase {
    private static CanonicalPath canonicalize(String path, CanonicalPath rootPath) {
        Object p = path == null || path.isEmpty() ? rootPath : org.hawkular.inventory.paths.Path.fromPartiallyUntypedString((String)path, (CanonicalPath)rootPath, (CanonicalPath)rootPath, (SegmentType)SegmentType.ANY_ENTITY);
        if (p.isRelative()) {
            p = p.toRelativePath().applyTo(rootPath);
        }
        return p.toCanonicalPath();
    }

    private static void putStatus(Map<ElementType, Map<CanonicalPath, Integer>> statuses, ElementType et, CanonicalPath cp, Integer status) {
        Map<CanonicalPath, Integer> typeStatuses = statuses.get(et);
        if (typeStatuses == null) {
            typeStatuses = new HashMap<CanonicalPath, Integer>();
            statuses.put(et, typeStatuses);
        }
        if (!typeStatuses.containsKey(cp)) {
            typeStatuses.put(cp, status);
        }
        if (status >= 200 && status < 300) {
            RestApiLogger.LOGGER.debugf("REST BULK created: %s", (Object)cp);
        } else {
            RestApiLogger.LOGGER.debugf("REST BULK failed (%d): %s", (Object)status, (Object)cp);
        }
    }

    private static boolean hasBeenProcessed(Map<ElementType, Map<CanonicalPath, Integer>> statuses, ElementType et, CanonicalPath cp) {
        Map<CanonicalPath, Integer> typeStatuses = statuses.get(et);
        return typeStatuses != null && typeStatuses.containsKey(cp);
    }

    private static String arrow(Relationship.Blueprint b) {
        switch (3.$SwitchMap$org$hawkular$inventory$api$Relationships$Direction[b.getDirection().ordinal()]) {
            case 1: {
                return "<-(" + b.getName() + ")->";
            }
            case 2: {
                return "-(" + b.getName() + ")->";
            }
            case 3: {
                return "<-(" + b.getName() + ")-";
            }
        }
        throw new IllegalStateException("Unhandled direction type: " + b.getDirection());
    }

    private static WriteInterface<?, ?, ?, ?> step(SegmentType elementClass, Class<?> nextType, ResolvableToSingle<?, ?> single) {
        return (WriteInterface)ElementTypeVisitor.accept((SegmentType)elementClass, (ElementTypeVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    private static <E extends AbstractElement<?, ?>> ResolvableToSingle<? extends AbstractElement<?, ?>, ?> create(Blueprint b, WriteInterface<?, ?, ?, ?> wrt) {
        return (ResolvableToSingle)b.accept((ElementBlueprintVisitor)new /* Unavailable Anonymous Inner Class!! */, null);
    }

    @POST
    @Path(value="/")
    @ApiOperation(value="Bulk creation of new entities.", notes="The response body contains details about results of creation of individual entities. The return value is a map where keys are types of entities created and values are again maps where keys are the canonical paths of the entities to be created and values are HTTP status codes - 201 OK, 400 if invalid path is supplied, 409 if the entity already exists on given path or 500 in case of internal error.")
    @ApiResponses(value={@ApiResponse(code=201, message="Entities successfully created")})
    public Response addEntities(@ApiParam(value="This is a map where keys are paths to the parents under which entities should be created. The values are again maps where keys are one of [environment, resourceType, metricType, operationType, feed, resource, metric, dataEntity, relationship] and values are arrays of blueprints of entities of the corresponding types.") Map<String, Map<ElementType, List<Object>>> entities, @Context UriInfo uriInfo) {
        CanonicalPath rootPath = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(this.getTenantId())).get();
        Map statuses = this.bulkCreate(entities, rootPath);
        return Response.status((Response.Status)Response.Status.CREATED).entity((Object)statuses).build();
    }

    private Map<ElementType, Map<CanonicalPath, Integer>> bulkCreate(Map<String, Map<ElementType, List<Object>>> entities, CanonicalPath rootPath) {
        HashMap<ElementType, Map<CanonicalPath, Integer>> statuses = new HashMap<ElementType, Map<CanonicalPath, Integer>>();
        TransactionFrame transaction = this.inventory.newTransactionFrame();
        Inventory binv = transaction.boundInventory();
        IdExtractor idExtractor = new IdExtractor();
        try {
            for (Map.Entry<String, Map<ElementType, List<Object>>> e : entities.entrySet()) {
                Map<ElementType, List<Object>> allBlueprints = e.getValue();
                CanonicalPath parentPath = RestBulk.canonicalize((String)e.getKey(), (CanonicalPath)rootPath);
                RestApiLogger.LOGGER.tracef("Bulk creating under %s", (Object)parentPath);
                ResolvableToSingle single = binv.inspect(parentPath, ResolvableToSingle.class);
                for (Map.Entry<ElementType, List<Object>> ee : allBlueprints.entrySet()) {
                    ElementType elementType = ee.getKey();
                    List<Object> rawBlueprints = ee.getValue();
                    List blueprints = this.deserializeBlueprints(elementType, rawBlueprints);
                    if (elementType == ElementType.relationship) {
                        this.bulkCreateRelationships(statuses, parentPath, (ResolvableToSingleWithRelationships)single, elementType, blueprints);
                        continue;
                    }
                    this.bulkCreateEntity(statuses, idExtractor, parentPath, single, elementType, blueprints);
                }
                RestApiLogger.LOGGER.tracef("Done bulk creating under %s", (Object)parentPath);
            }
            transaction.commit();
            return statuses;
        }
        catch (Throwable t) {
            transaction.rollback();
            throw t;
        }
    }

    private List<Blueprint> deserializeBlueprints(ElementType elementType, List<Object> rawBlueprints) {
        return rawBlueprints.stream().map(o -> {
            try {
                String js = this.getMapper().writeValueAsString(o);
                return (Blueprint)this.getMapper().reader(elementType.blueprintType).readValue(js);
            }
            catch (IOException e1) {
                throw new IllegalArgumentException("Failed to deserialize as " + elementType.blueprintType + " the following data: " + o, e1);
            }
        }).collect(Collectors.toList());
    }

    private void bulkCreateEntity(Map<ElementType, Map<CanonicalPath, Integer>> statuses, IdExtractor idExtractor, CanonicalPath parentPath, ResolvableToSingle<? extends AbstractElement<?, ?>, ?> single, ElementType elementType, List<Blueprint> blueprints) {
        if (!parentPath.modified().canExtendTo(elementType.segmentType).booleanValue()) {
            RestApiLogger.LOGGER.debugf("Element type %s cannot be created under parent %s. Aborting bulk create.", (Object)elementType.segmentType, (Object)parentPath);
            RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath, (Integer)Response.Status.BAD_REQUEST.getStatusCode());
            return;
        }
        if (!this.canCreateUnderParent(elementType, parentPath, statuses)) {
            for (Blueprint b : blueprints) {
                String id = (String)b.accept((ElementBlueprintVisitor)idExtractor, null);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath.extend(elementType.segmentType, id).get(), (Integer)Response.Status.FORBIDDEN.getStatusCode());
            }
            return;
        }
        for (Blueprint b : blueprints) {
            WriteInterface wrt = RestBulk.step((SegmentType)parentPath.getSegment().getElementType(), (Class)elementType.elementType, single);
            CanonicalPath provisionalChildPath = parentPath.extend(elementType.segmentType, (String)b.accept((ElementBlueprintVisitor)idExtractor, null)).get();
            boolean hasBeenProcessed = RestBulk.hasBeenProcessed(statuses, (ElementType)elementType, (CanonicalPath)provisionalChildPath);
            if (hasBeenProcessed) {
                RestApiLogger.LOGGER.tracef("Skipping creation of %s. It seems to have been processed already", (Object)provisionalChildPath);
                continue;
            }
            try {
                String childId = ((AbstractElement)RestBulk.create((Blueprint)b, (WriteInterface)wrt).entity()).getId();
                CanonicalPath childPath = parentPath.extend(elementType.segmentType, childId).get();
                RestApiLogger.LOGGER.tracef("Created %s", (Object)childPath);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)childPath, (Integer)Response.Status.CREATED.getStatusCode());
            }
            catch (EntityAlreadyExistsException ex) {
                RestApiLogger.LOGGER.tracef("Entity already exists during bulk create: " + provisionalChildPath, new Object[0]);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)provisionalChildPath, (Integer)Response.Status.CONFLICT.getStatusCode());
            }
            catch (Exception ex) {
                RestApiLogger.LOGGER.failedToCreateBulkEntity(provisionalChildPath, (Throwable)ex);
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)provisionalChildPath, (Integer)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
    }

    private void bulkCreateRelationships(Map<ElementType, Map<CanonicalPath, Integer>> statuses, CanonicalPath parentPath, ResolvableToSingleWithRelationships<?, ?> single, ElementType elementType, List<Blueprint> blueprints) {
        if (!this.hasBeenCreatedInBulk(parentPath, statuses) && !this.security.canAssociateFrom(parentPath)) {
            for (Blueprint b : blueprints) {
                Relationship.Blueprint rb = (Relationship.Blueprint)b;
                String id = parentPath.toString() + RestBulk.arrow((Relationship.Blueprint)rb) + rb.getOtherEnd();
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)parentPath.extend(elementType.segmentType, id).get(), (Integer)Response.Status.FORBIDDEN.getStatusCode());
            }
            return;
        }
        for (Blueprint b : blueprints) {
            Relationship.Blueprint rb = (Relationship.Blueprint)b;
            String fakeId = parentPath.toString() + RestBulk.arrow((Relationship.Blueprint)rb) + rb.getOtherEnd().toString();
            CanonicalPath cPath = (CanonicalPath)((CanonicalPath.RelationshipBuilder)CanonicalPath.of().relationship(fakeId)).get();
            boolean hasBeenProcessed = RestBulk.hasBeenProcessed(statuses, (ElementType)elementType, (CanonicalPath)cPath);
            if (hasBeenProcessed) continue;
            try {
                Relationships.Single rel = (Relationships.Single)((Relationships.ReadWrite)single.relationships(rb.getDirection())).linkWith(rb.getName(), rb.getOtherEnd(), rb.getProperties());
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)cPath, (Integer)Response.Status.CREATED.getStatusCode());
            }
            catch (EntityNotFoundException ex) {
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)cPath, (Integer)Response.Status.NOT_FOUND.getStatusCode());
            }
            catch (RelationAlreadyExistsException ex) {
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)cPath, (Integer)Response.Status.CONFLICT.getStatusCode());
            }
            catch (Exception ex) {
                RestBulk.putStatus(statuses, (ElementType)elementType, (CanonicalPath)cPath, (Integer)Response.Status.INTERNAL_SERVER_ERROR.getStatusCode());
            }
        }
    }

    private boolean canCreateUnderParent(ElementType elementType, CanonicalPath parentPath, Map<ElementType, Map<CanonicalPath, Integer>> statuses) {
        if (this.hasBeenCreatedInBulk(parentPath, statuses)) {
            return true;
        }
        switch (3.$SwitchMap$org$hawkular$inventory$rest$RestBulk$ElementType[elementType.ordinal()]) {
            case 1: {
                return this.security.canUpdate(parentPath);
            }
            case 2: {
                throw new IllegalArgumentException("Cannot create anything under a relationship.");
            }
        }
        return this.security.canCreate(elementType.elementType).under(parentPath);
    }

    private boolean hasBeenCreatedInBulk(CanonicalPath elementPath, Map<ElementType, Map<CanonicalPath, Integer>> statuses) {
        Map<CanonicalPath, Integer> elementsOfType = statuses.get(ElementType.ofSegmentType((SegmentType)elementPath.getSegment().getElementType()));
        if (elementsOfType == null) {
            return false;
        }
        Integer status = elementsOfType.get(elementPath);
        if (status == null) {
            return false;
        }
        return status == 201 || status == 204;
    }

    static /* synthetic */ String access$000(Relationship.Blueprint x0) {
        return RestBulk.arrow((Relationship.Blueprint)x0);
    }
}

