/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.interceptors;

import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.ws.rs.ext.Provider;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.rest.interceptors.CorsFilter;
import org.hawkular.jaxrs.filter.cors.AbstractCorsResponseFilter;
import org.jboss.resteasy.annotations.interception.ServerInterceptor;

@Provider
@ServerInterceptor
public class CorsFilter
extends AbstractCorsResponseFilter {
    @Inject
    private Configuration configuration;
    private OriginValidation originValidation;
    private String extraAllowedHeaders;

    @PostConstruct
    protected void initValidation() {
        String allowedOrigins = this.configuration.getProperty((Configuration.Property)CorsProperties.ALLOWED_CORS_ORIGINS, "*");
        this.originValidation = new OriginValidation(allowedOrigins);
        String headers = this.configuration.getProperty((Configuration.Property)CorsProperties.ALLOWED_CORS_ACCESS_CONTROL_ALLOW_HEADERS, null);
        this.extraAllowedHeaders = "authorization";
        if (headers != null) {
            this.extraAllowedHeaders = this.extraAllowedHeaders + "," + headers;
        }
    }

    protected boolean isAllowedOrigin(String requestOrigin) {
        return this.originValidation.isAllowedOrigin(requestOrigin);
    }

    protected String getExtraAccessControlAllowHeaders() {
        return this.extraAllowedHeaders;
    }
}

