/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.IOException;
import java.io.Reader;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.Synced;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.SyncHash;
import org.hawkular.inventory.api.model.Syncable;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.Path;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.Utils;
import org.jboss.resteasy.spi.BadRequestException;

@javax.ws.rs.Path(value="/entity")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RestEntity
extends RestBase {
    public RestEntity() {
        super("/entity".length());
    }

    @GET
    @javax.ws.rs.Path(value="{path:.+}/treeHash")
    public SyncHash.Tree getTreeHash(@Context UriInfo uriInfo) throws Exception {
        CanonicalPath path = CanonicalPath.fromPartiallyUntypedString((String)this.getPath(uriInfo, "/treeHash".length()), (CanonicalPath)this.getTenantPath(), AbstractElement.class);
        Class eltType = Inventory.types().byPath((Path)path).getElementType();
        if (!Syncable.class.isAssignableFrom(eltType)) {
            throw new BadRequestException("Element not syncable - cannot get treeHash for path " + path);
        }
        return ((Synced.Single)this.inventory.inspect(path, Synced.Single.class)).treeHash();
    }

    @GET
    @javax.ws.rs.Path(value="{path:.+}")
    public Object get(@Context UriInfo uriInfo) throws Exception {
        CanonicalPath path = CanonicalPath.fromPartiallyUntypedString((String)this.getPath(uriInfo), (CanonicalPath)this.getTenantPath(), AbstractElement.class);
        return this.inventory.inspect(path, ResolvableToSingle.class).entity();
    }

    @POST
    @javax.ws.rs.Path(value="{path:.+}")
    public Response post(@Context UriInfo uriInfo, Reader input) throws Exception {
        String pathAndType = this.getPath(uriInfo);
        int slashIdx = pathAndType.lastIndexOf(47);
        String parent = pathAndType.substring(0, slashIdx);
        String entityType = pathAndType.substring(slashIdx + 1);
        SegmentType st = Utils.getSegmentTypeFromSimpleName((String)entityType);
        if (parent.isEmpty()) {
            parent = "/";
        }
        CanonicalPath parentPath = CanonicalPath.fromPartiallyUntypedString((String)parent, (CanonicalPath)this.getTenantPath(), AbstractElement.class);
        if (st == SegmentType.rl ? !this.security.canAssociateFrom(parentPath) : !this.security.canCreate(Inventory.types().bySegment(st).getElementType()).under(parentPath)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Object toReport = this.create(parentPath, st, input);
        if (toReport instanceof Collection) {
            return ResponseUtil.created((Collection)((Collection)toReport), (UriInfo)uriInfo).build();
        }
        return ResponseUtil.created((AbstractElement)((AbstractElement)toReport), (UriInfo)uriInfo).build();
    }

    @PUT
    @javax.ws.rs.Path(value="{path:.+}")
    public Response put(@Context UriInfo uriInfo, Reader input) throws Exception {
        String path = this.getPath(uriInfo);
        CanonicalPath entityPath = CanonicalPath.fromPartiallyUntypedString((String)path, (CanonicalPath)this.getTenantPath(), AbstractElement.class);
        if (!this.security.canUpdate(entityPath)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        Class updateType = Inventory.types().byPath((Path)entityPath).getUpdateType();
        this.doPut(entityPath, updateType, input);
        return Response.noContent().build();
    }

    @DELETE
    @javax.ws.rs.Path(value="{path:.+}")
    @ApiOperation(value="Deletes an inventory entity on the given location.")
    @ApiResponses(value={@ApiResponse(code=204, message="Entity deleted."), @ApiResponse(code=404, message="No entity found on given traversal URI."), @ApiResponse(code=500, message="Internal server error")})
    public Response delete(@Context UriInfo uriInfo) {
        Relationship rl;
        String path = this.getPath(uriInfo);
        CanonicalPath entityPath = CanonicalPath.fromPartiallyUntypedString((String)path, (CanonicalPath)this.getTenantPath(), AbstractElement.class);
        if (entityPath.getSegment().getElementType() == SegmentType.rl ? !this.security.canAssociateFrom((rl = (Relationship)((Relationships.Single)this.inventory.inspect(entityPath, Relationships.Single.class)).entity()).getSource()) : !this.security.canDelete(entityPath)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        this.inventory.inspect(entityPath, Inventory.types().byPath((Path)entityPath).getSingleAccessorType()).delete();
        return Response.noContent().build();
    }

    private <U extends AbstractElement.Update> void doPut(CanonicalPath path, Class<U> updateType, Reader data) throws IOException {
        this.setupMapper(path);
        AbstractElement.Update update = (AbstractElement.Update)this.getMapper().reader().forType(updateType).readValue(data);
        this.inventory.inspect(path, Inventory.types().byUpdate(updateType).getSingleAccessorType()).update((Object)update);
    }
}

