/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.util.List;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.PathSegment;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.api.Synced;
import org.hawkular.inventory.api.model.InventoryStructure;
import org.hawkular.inventory.api.model.SyncRequest;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RestApiLogger;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/sync")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/sync", description="Synchronization of entity trees", tags={"Sync"})
public class RestSync
extends RestBase {
    public RestSync() {
        super("/sync".length());
    }

    @POST
    @Path(value="/{path:.+}")
    @ApiOperation(value="Make the inventory under given path match the provided inventory structure. Note that the relationships specified in the provided entities will be ignored and will not be applied.")
    @ApiResponses(value={@ApiResponse(code=204, message="Synchronization success"), @ApiResponse(code=400, message="If the entity to be synchronized doesn't support synchronization", response=ApiError.class), @ApiResponse(code=404, message="Authorization problem", response=ApiError.class), @ApiResponse(code=500, message="Internal server error", response=ApiError.class)})
    public Response sync(@Encoded @PathParam(value="path") List<PathSegment> path, SyncRequest<?> req) {
        CanonicalPath cp = this.parsePath(path);
        if (!InventoryStructure.EntityType.supports((SegmentType)cp.getSegment().getElementType())) {
            throw new IllegalArgumentException("Entities of type " + cp.getSegment().getElementType().getSimpleName() + " are not synchronizable.");
        }
        RestApiLogger.LOGGER.commencingSync(cp);
        long startTime = System.currentTimeMillis();
        ((Synced.SingleWithRelationships)this.inventory.inspect(cp, Synced.SingleWithRelationships.class)).synchronize(req);
        RestApiLogger.LOGGER.syncFinished(cp, System.currentTimeMillis() - startTime);
        return Response.noContent().build();
    }
}

