/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import java.io.IOException;
import java.io.Reader;
import java.net.URISyntaxException;
import java.util.Collection;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Query;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.paths.SegmentType;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.Traverser;

@Path(value="/tenant")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class RestTenant
extends RestBase {
    public RestTenant() {
        super("/tenant".length());
    }

    @GET
    public Tenant get() {
        return (Tenant)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).entity();
    }

    @PUT
    public Response put(Tenant.Update update) {
        ((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).update((Object)update);
        return Response.noContent().build();
    }

    @GET
    @Path(value="/relationships")
    public Response getRelationships(@Context UriInfo uriInfo) {
        Traverser traverser = this.getTraverser(uriInfo);
        Query q = traverser.navigate(this.getPath(uriInfo));
        Page results = this.inventory.execute(q, AbstractElement.class, RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, results).build();
    }

    @POST
    @Path(value="/relationship")
    public Response createRelationships(@Context UriInfo uriInfo, Reader input) throws IOException, URISyntaxException {
        CanonicalPath tenant = this.getTenantPath();
        Object toReport = this.create(tenant, SegmentType.rl, input);
        if (toReport instanceof Collection) {
            return ResponseUtil.created((Collection)((Collection)toReport), (UriInfo)uriInfo).build();
        }
        return ResponseUtil.created((AbstractElement)((AbstractElement)toReport), (UriInfo)uriInfo).build();
    }
}

