/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.deprecated;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Parents;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.paths.CanonicalPath;
import org.hawkular.inventory.rest.RequestUtil;
import org.hawkular.inventory.rest.ResponseUtil;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/deprecated")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/deprecated", description="Metric types CRUD", tags={"Deprecated"})
public class RestMetricTypes
extends RestBase {
    @GET
    @Path(value="/metricTypes")
    @ApiOperation(value="Retrieves all metric types. Accepts paging query parameters")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@QueryParam(value="feedless") @DefaultValue(value="false") boolean feedless, @Context UriInfo uriInfo) {
        Tenants.Single tenants = (Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId());
        Page ret = ((MetricTypes.Multiple)(feedless ? (ReadInterface)tenants.metricTypes() : tenants.metricTypesUnder((Tenants.MetricTypeParents[])Parents.any())).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Retrieves a single metric type")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public MetricType get(@PathParam(value="metricTypeId") String metricTypeId) {
        return (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).metricTypes()).get((Object)metricTypeId)).entity();
    }

    @GET
    @Path(value="/feeds/{feedId}/metricTypes")
    @ApiOperation(value="Retrieves all metric types under feed. Accepts paging query parameters.")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response getAll(@PathParam(value="feedId") String feedId, @Context UriInfo uriInfo) {
        Page ret = ((MetricTypes.Multiple)((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feeds()).get((Object)feedId)).metricTypes()).getAll(new Filter[0])).entities(RequestUtil.extractPaging((UriInfo)uriInfo));
        return this.pagedResponse(Response.ok(), uriInfo, ret).build();
    }

    @GET
    @Path(value="/feeds/{feedId}/metricTypes/{metricTypeId}")
    @ApiOperation(value="Retrieves a single metric type under feed")
    @ApiResponses(value={@ApiResponse(code=200, message="OK"), @ApiResponse(code=404, message="Metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public MetricType get(@PathParam(value="feedId") String feedId, @PathParam(value="metricTypeId") String metricTypeId) {
        return (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)this.getTenantId())).feeds()).get((Object)feedId)).metricTypes()).get((Object)metricTypeId)).entity();
    }

    @POST
    @Path(value="/metricTypes")
    @ApiOperation(value="Creates a new metric type")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric type successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Metric type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@ApiParam(required=true) MetricType.Blueprint metricType, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).get();
        if (!this.security.canCreate(MetricType.class).under(tenant)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MetricType entity = this.createMetricType((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.inspect(tenant, Tenants.Single.class)).metricTypes(), metricType);
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)metricType.getId()).build();
    }

    @POST
    @Path(value="/feeds/{feedId}/metricTypes")
    @ApiOperation(value="Creates a new metric type under feed")
    @ApiResponses(value={@ApiResponse(code=201, message="Metric type successfully created"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=409, message="Metric type already exists", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response create(@PathParam(value="feedId") String feedId, @ApiParam(required=true) MetricType.Blueprint metricType, @Context UriInfo uriInfo) {
        String tenantId = this.getTenantId();
        CanonicalPath feed = (CanonicalPath)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).get();
        if (!this.security.canCreate(MetricType.class).under(feed)) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        MetricType entity = this.createMetricType((MetricTypes.ReadWrite)((Feeds.Single)this.inventory.inspect(feed, Feeds.Single.class)).metricTypes(), metricType);
        return ResponseUtil.created((AbstractElement)entity, (UriInfo)uriInfo, (String)metricType.getId()).build();
    }

    private MetricType createMetricType(MetricTypes.ReadWrite accessInterface, MetricType.Blueprint metricType) {
        if (metricType == null) {
            throw new IllegalArgumentException("metricType to create not specified");
        }
        if (metricType.getId() == null) {
            throw new IllegalArgumentException("metricType id not specified");
        }
        return (MetricType)((MetricTypes.Single)accessInterface.create((Blueprint)metricType)).entity();
    }

    @PUT
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Updates a metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully updated"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="metricTypeId") String metricTypeId, @ApiParam(required=true) MetricType.Update update) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metricType(metricTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metricTypes()).update((Object)metricTypeId, (Object)update);
        return Response.noContent().build();
    }

    @PUT
    @Path(value="/feeds/{feedId}/metricTypes/{metricTypeId}")
    @ApiOperation(value="Updates a metric type under feed")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully updated"), @ApiResponse(code=400, message="Invalid input data", response=ApiError.class), @ApiResponse(code=404, message="Tenant doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response update(@PathParam(value="feedId") String feedId, @PathParam(value="metricTypeId") String metricTypeId, @ApiParam(required=true) MetricType.Update update) throws Exception {
        String tenantId = this.getTenantId();
        if (!this.security.canUpdate((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).metricType(metricTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).metricTypes()).update((Object)metricTypeId, (Object)update);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/metricTypes/{metricTypeId}")
    @ApiOperation(value="Deletes a metric type")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully deleted"), @ApiResponse(code=400, message="Metric type cannot be deleted because of constraints on it", response=ApiError.class), @ApiResponse(code=404, message="Tenant or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="metricTypeId") String metricTypeId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).metricType(metricTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).metricTypes()).delete((Object)metricTypeId);
        return Response.noContent().build();
    }

    @DELETE
    @Path(value="/feeds/{feedId}/metricTypes/{metricTypeId}")
    @ApiOperation(value="Deletes a metric type under feed")
    @ApiResponses(value={@ApiResponse(code=204, message="Metric type successfully deleted"), @ApiResponse(code=400, message="Metric type cannot be deleted because of constraints on it", response=ApiError.class), @ApiResponse(code=404, message="Tenant or metric type doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response delete(@PathParam(value="feedId") String feedId, @PathParam(value="metricTypeId") String metricTypeId) {
        String tenantId = this.getTenantId();
        if (!this.security.canDelete((CanonicalPath)((CanonicalPath.MetricTypeBuilder)((CanonicalPath.FeedBuilder)((CanonicalPath.TenantBuilder)CanonicalPath.of().tenant(tenantId)).feed(feedId)).metricType(metricTypeId)).get())) {
            return Response.status((Response.Status)Response.Status.FORBIDDEN).build();
        }
        ((MetricTypes.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Tenants.Single)this.inventory.tenants().get((Object)tenantId)).feeds()).get((Object)feedId)).metricTypes()).delete((Object)metricTypeId);
        return Response.noContent().build();
    }
}

