/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.pipes.Pipe;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.hawkular.inventory.api.filters.Contained;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Incorporated;
import org.hawkular.inventory.api.filters.Marker;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.base.FilterFragment;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.QueryFragment;
import org.hawkular.inventory.base.spi.NoopFilter;
import org.hawkular.inventory.base.spi.SwitchElementType;
import org.hawkular.inventory.impl.tinkerpop.FilterVisitor;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;

abstract class FilterApplicator<T extends Filter> {
    private static Map<Class<? extends Filter>, Class<? extends FilterApplicator<?>>> applicators = new HashMap();
    protected final T filter;
    protected final FilterVisitor visitor = new FilterVisitor();

    private FilterApplicator(T f) {
        this.filter = f;
    }

    public static FilterApplicator of(Filter filter) {
        if (filter == null) {
            throw new IllegalArgumentException("filter == null");
        }
        Class<?> filterClazz = filter.getClass();
        Class<FilterApplicator<?>> applicatorClazz = applicators.get(filterClazz);
        if (applicatorClazz == null) {
            throw new IllegalArgumentException("Unsupported filter type " + filterClazz);
        }
        Constructor<FilterApplicator<?>> constructor = null;
        try {
            constructor = applicatorClazz.getDeclaredConstructor(filterClazz);
        }
        catch (NoSuchMethodException e) {
            try {
                constructor = applicatorClazz.getDeclaredConstructor(filterClazz.getSuperclass());
            }
            catch (NoSuchMethodException e1) {
                throw new IllegalArgumentException("Unable to create an instance of " + applicatorClazz);
            }
        }
        try {
            constructor.setAccessible(true);
            return constructor.newInstance(filter);
        }
        catch (IllegalAccessException | InstantiationException | InvocationTargetException e) {
            throw new IllegalArgumentException("Unable to create an instance of " + applicatorClazz);
        }
    }

    public static <S, E> void applyAll(Query filterTree, HawkularPipeline<S, E> q) {
        if (filterTree == null) {
            return;
        }
        if (FilterApplicator.applyAll(filterTree, q, false)) {
            q.recall();
        }
    }

    private static <S, E> boolean applyAll(Query query, HawkularPipeline<S, E> pipeline, boolean isFilter) {
        for (QueryFragment qf : query.getFragments()) {
            boolean thisIsFilter = qf instanceof FilterFragment;
            if (thisIsFilter != isFilter) {
                isFilter = thisIsFilter;
                if (thisIsFilter) {
                    pipeline.remember();
                } else {
                    pipeline.recall();
                }
            }
            FilterApplicator.of(qf.getFilter()).applyTo(pipeline);
        }
        if (query.getSubTrees().isEmpty()) {
            return isFilter;
        }
        if (query.getSubTrees().size() == 1) {
            return FilterApplicator.applyAll((Query)query.getSubTrees().get(0), pipeline, isFilter);
        }
        ArrayList branches = new ArrayList();
        Iterator it = query.getSubTrees().iterator();
        HawkularPipeline branch = new HawkularPipeline();
        boolean newIsFilter = FilterApplicator.applyAll((Query)it.next(), branch, false);
        if (newIsFilter) {
            branch.recall();
        }
        branches.add(branch);
        while (it.hasNext()) {
            branch = new HawkularPipeline();
            boolean nextIsFilter = FilterApplicator.applyAll((Query)it.next(), branch, false);
            if (nextIsFilter) {
                branch.recall();
            }
            if (nextIsFilter != newIsFilter) {
                throw new IllegalArgumentException("The branches of the query [" + query + "] don't change" + " the path/filter state consistently.");
            }
            branches.add(branch);
        }
        pipeline.copySplit((Pipe[])branches.toArray(new HawkularPipeline[branches.size()])).exhaustMerge();
        return isFilter;
    }

    public abstract void applyTo(HawkularPipeline<?, ?> var1);

    public Filter filter() {
        return this.filter;
    }

    public String toString() {
        return "FilterApplicator[filter=" + this.filter + "]";
    }

    /* synthetic */ FilterApplicator(Filter x0, 1 x1) {
        this(x0);
    }

    static {
        applicators.put(Related.class, RelatedApplicator.class);
        applicators.put(Contained.class, RelatedApplicator.class);
        applicators.put(Defined.class, RelatedApplicator.class);
        applicators.put(Incorporated.class, RelatedApplicator.class);
        applicators.put(With.Ids.class, WithIdsApplicator.class);
        applicators.put(With.Types.class, WithTypesApplicator.class);
        applicators.put(With.PropertyValues.class, WithPropertyValuesApplicator.class);
        applicators.put(RelationWith.Ids.class, RelationWithIdsApplicator.class);
        applicators.put(RelationWith.PropertyValues.class, RelationWithPropertiesApplicator.class);
        applicators.put(RelationWith.SourceOfType.class, RelationWithSourcesOfTypesApplicator.class);
        applicators.put(RelationWith.TargetOfType.class, RelationWithTargetsOfTypesApplicator.class);
        applicators.put(RelationWith.SourceOrTargetOfType.class, RelationWithSourcesOrTargetsOfTypesApplicator.class);
        applicators.put(SwitchElementType.class, SwitchElementTypeApplicator.class);
        applicators.put(NoopFilter.class, NoopApplicator.class);
        applicators.put(With.CanonicalPaths.class, CanonicalPathApplicator.class);
        applicators.put(With.RelativePaths.class, RelativePathApplicator.class);
        applicators.put(Marker.class, MarkerApplicator.class);
        applicators.put(With.DataAt.class, DataAtApplicator.class);
        applicators.put(With.DataValued.class, DataValuedApplicator.class);
        applicators.put(With.DataOfTypes.class, DataOfTypesApplicator.class);
    }

    private static final class DataOfTypesApplicator
    extends FilterApplicator<With.DataOfTypes> {
        private DataOfTypesApplicator(With.DataOfTypes f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.DataOfTypes)this.filter);
        }
    }

    private static final class DataValuedApplicator
    extends FilterApplicator<With.DataValued> {
        private DataValuedApplicator(With.DataValued f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.DataValued)this.filter);
        }
    }

    private static final class DataAtApplicator
    extends FilterApplicator<With.DataAt> {
        private DataAtApplicator(With.DataAt f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.DataAt)this.filter);
        }
    }

    private static final class MarkerApplicator
    extends FilterApplicator<Marker> {
        private MarkerApplicator(Marker f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (Marker)this.filter);
        }
    }

    private static final class RelativePathApplicator
    extends FilterApplicator<With.RelativePaths> {
        private RelativePathApplicator(With.RelativePaths f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.RelativePaths)this.filter);
        }
    }

    private static final class CanonicalPathApplicator
    extends FilterApplicator<With.CanonicalPaths> {
        private CanonicalPathApplicator(With.CanonicalPaths f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.CanonicalPaths)this.filter);
        }
    }

    private static final class WithPropertyValuesApplicator
    extends FilterApplicator<With.PropertyValues> {
        private WithPropertyValuesApplicator(With.PropertyValues f) {
            super((Filter)f, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.PropertyValues)this.filter);
        }
    }

    private static final class NoopApplicator
    extends FilterApplicator<NoopFilter> {
        private NoopApplicator(NoopFilter filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (NoopFilter)this.filter);
        }
    }

    private static final class SwitchElementTypeApplicator
    extends FilterApplicator<SwitchElementType> {
        private SwitchElementTypeApplicator(SwitchElementType filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (SwitchElementType)this.filter);
        }
    }

    private static final class RelationWithSourcesOrTargetsOfTypesApplicator
    extends FilterApplicator<RelationWith.SourceOrTargetOfType> {
        private RelationWithSourcesOrTargetsOfTypesApplicator(RelationWith.SourceOrTargetOfType filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (RelationWith.SourceOrTargetOfType)this.filter);
        }
    }

    private static final class RelationWithTargetsOfTypesApplicator
    extends FilterApplicator<RelationWith.TargetOfType> {
        private RelationWithTargetsOfTypesApplicator(RelationWith.TargetOfType filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (RelationWith.TargetOfType)this.filter);
        }
    }

    private static final class RelationWithSourcesOfTypesApplicator
    extends FilterApplicator<RelationWith.SourceOfType> {
        private RelationWithSourcesOfTypesApplicator(RelationWith.SourceOfType filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (RelationWith.SourceOfType)this.filter);
        }
    }

    private static final class RelationWithPropertiesApplicator
    extends FilterApplicator<RelationWith.PropertyValues> {
        private RelationWithPropertiesApplicator(RelationWith.PropertyValues filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (RelationWith.PropertyValues)this.filter);
        }
    }

    private static final class RelationWithIdsApplicator
    extends FilterApplicator<RelationWith.Ids> {
        private RelationWithIdsApplicator(RelationWith.Ids filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (RelationWith.Ids)this.filter);
        }
    }

    private static final class WithTypesApplicator
    extends FilterApplicator<With.Types> {
        private WithTypesApplicator(With.Types filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.Types)this.filter);
        }
    }

    private static final class WithIdsApplicator
    extends FilterApplicator<With.Ids> {
        private WithIdsApplicator(With.Ids filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (With.Ids)this.filter);
        }
    }

    private static final class RelatedApplicator
    extends FilterApplicator<Related> {
        private RelatedApplicator(Related filter) {
            super((Filter)filter, null);
        }

        @Override
        public void applyTo(HawkularPipeline<?, ?> query) {
            this.visitor.visit(query, (Related)this.filter);
        }
    }
}

