/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Compare;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.filter.PropertyFilterPipe;
import com.tinkerpop.pipes.util.Pipeline;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Marker;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.base.spi.NoopFilter;
import org.hawkular.inventory.base.spi.SwitchElementType;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;

class FilterVisitor {
    FilterVisitor() {
    }

    public void visit(HawkularPipeline<?, ?> query, Related related) {
        switch (related.getEntityRole()) {
            case TARGET: {
                if (null != related.getRelationshipName()) {
                    query.in(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.inE(new String[0]).hasEid(related.getRelationshipId()).inV();
                break;
            }
            case SOURCE: {
                if (null != related.getRelationshipName()) {
                    query.out(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.outE(new String[0]).hasEid(related.getRelationshipId()).outV();
                break;
            }
            case ANY: {
                if (null != related.getRelationshipName()) {
                    query.both(new String[]{related.getRelationshipName()});
                }
                if (null == related.getRelationshipId()) break;
                query.bothE(new String[0]).hasEid(related.getRelationshipId()).bothV();
            }
        }
        if (related.getEntityPath() != null) {
            query.hasCanonicalPath(related.getEntityPath());
        }
    }

    public void visit(HawkularPipeline<?, ?> query, With.Ids ids) {
        if (ids.getIds().length == 1) {
            query.has(Constants.Property.__eid.name(), ids.getIds()[0]);
            return;
        }
        Pipe[] idChecks = new Pipe[ids.getIds().length];
        Arrays.setAll(idChecks, i -> new PropertyFilterPipe(Constants.Property.__eid.name(), (Predicate)Compare.EQUAL, (Object)ids.getIds()[i]));
        query.or(idChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, With.Types types) {
        if (types.getTypes().length == 1) {
            Constants.Type type = Constants.Type.of(types.getTypes()[0]);
            query.has(Constants.Property.__type.name(), type.name());
            return;
        }
        Pipe[] typeChecks = new Pipe[types.getTypes().length];
        Arrays.setAll(typeChecks, i -> {
            Constants.Type type = Constants.Type.of(types.getTypes()[i]);
            return new PropertyFilterPipe(Constants.Property.__type.name(), (Predicate)Compare.EQUAL, (Object)type.name());
        });
        query.or(typeChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.Ids ids) {
        if (ids.getIds().length == 1) {
            query.hasEid(ids.getIds()[0]);
            return;
        }
        Pipe[] idChecks = new Pipe[ids.getIds().length];
        Arrays.setAll(idChecks, i -> new PropertyFilterPipe(Constants.Property.__eid.name(), (Predicate)Compare.EQUAL, (Object)ids.getIds()[i]));
        query.or(idChecks);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.PropertyValues properties) {
        this.applyPropertyFilter(query, properties.getProperty(), properties.getValues());
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOfType types) {
        this.visit(query, (RelationWith.SourceOrTargetOfType)types, true);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.TargetOfType types) {
        this.visit(query, (RelationWith.SourceOrTargetOfType)types, false);
    }

    public void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOrTargetOfType types) {
        this.visit(query, types, null);
    }

    private void visit(HawkularPipeline<?, ?> query, RelationWith.SourceOrTargetOfType types, Boolean source) {
        HawkularPipeline<?, ?> q1 = query.remember();
        GremlinPipeline q2 = source == null ? q1.bothV() : (source != false ? q1.outV() : q1.inV());
        if (types.getTypes().length == 1) {
            Constants.Type type = Constants.Type.of(types.getTypes()[0]);
            q2.has(Constants.Property.__type.name(), type.name()).recall();
            return;
        }
        Pipe[] typeChecks = new Pipe[types.getTypes().length];
        Arrays.setAll(typeChecks, i -> {
            Constants.Type type = Constants.Type.of(types.getTypes()[i]);
            return new PropertyFilterPipe(Constants.Property.__type.name(), (Predicate)Compare.EQUAL, (Object)type.name());
        });
        q2.or(typeChecks).recall();
    }

    public void visit(HawkularPipeline<?, ?> query, SwitchElementType filter) {
        boolean jumpFromEdge = filter.isFromEdge();
        switch (filter.getDirection()) {
            case incoming: {
                if (jumpFromEdge) {
                    query.outV();
                    break;
                }
                query.inE(new String[0]);
                break;
            }
            case outgoing: {
                if (jumpFromEdge) {
                    query.inV();
                    break;
                }
                query.outE(new String[0]);
                break;
            }
            case both: {
                if (jumpFromEdge) {
                    query.bothV();
                    break;
                }
                query.bothE(new String[0]);
            }
        }
    }

    public void visit(HawkularPipeline<?, ?> query, NoopFilter filter) {
    }

    public void visit(HawkularPipeline<?, ?> query, With.PropertyValues filter) {
        this.applyPropertyFilter(query, filter.getName(), filter.getValues());
    }

    private void applyPropertyFilter(HawkularPipeline<?, ?> query, String propertyName, Object ... values) {
        if (values.length == 0) {
            query.has(propertyName);
        } else if (values.length == 1) {
            query.has(propertyName, values[0]);
        } else {
            Pipe[] checks = new Pipe[values.length];
            Arrays.setAll(checks, i -> new PropertyFilterPipe(propertyName, (Predicate)Compare.EQUAL, values[i]));
            query.or(checks);
        }
    }

    public void visit(HawkularPipeline<?, ?> query, With.CanonicalPaths filter) {
        if (filter.getPaths().length == 1) {
            query.has(Constants.Property.__cp.name(), filter.getPaths()[0].toString());
            return;
        }
        Pipe[] idChecks = new Pipe[filter.getPaths().length];
        Arrays.setAll(idChecks, i -> new PropertyFilterPipe(Constants.Property.__cp.name(), (Predicate)Compare.EQUAL, (Object)filter.getPaths()[i].toString()));
        query.or(idChecks);
    }

    public <E> void visit(HawkularPipeline<?, E> query, With.RelativePaths filter) {
        String label = filter.getMarkerLabel();
        HashSet seen = new HashSet();
        if (filter.getPaths().length == 1) {
            if (label != null) {
                this.apply(filter.getPaths()[0].getSegment(), query);
                query.store((Collection)seen);
                query.back(label);
            }
            this.convertToPipeline(filter.getPaths()[0], query);
        } else {
            if (label != null) {
                HawkularPipeline[] narrower = new HawkularPipeline[filter.getPaths().length];
                Arrays.setAll(narrower, i -> {
                    HawkularPipeline p = new HawkularPipeline();
                    this.apply(filter.getPaths()[i].getSegment(), p);
                    return p;
                });
                query.or((Pipe[])narrower);
                query.store((Collection)seen);
                query.back(label);
            }
            HawkularPipeline[] pipes = new HawkularPipeline[filter.getPaths().length];
            Arrays.setAll(pipes, i -> {
                HawkularPipeline p = new HawkularPipeline();
                this.convertToPipeline(filter.getPaths()[i], p);
                return p;
            });
            query.or((Pipe[])pipes);
        }
        if (label != null) {
            query.retain((Collection)seen);
        }
    }

    public void visit(HawkularPipeline<?, ?> query, Marker filter) {
        query._().as(filter.getLabel());
    }

    public void visit(HawkularPipeline<?, ?> query, With.DataAt dataPos) {
        query.out(Relationships.WellKnown.hasData);
        for (Path.Segment seg : dataPos.getDataPath().getPath()) {
            if (RelativePath.Up.class.equals((Object)seg.getElementType())) {
                query.in(Relationships.WellKnown.contains);
            } else {
                query.out(Relationships.WellKnown.contains);
            }
            query.hasType(Constants.Type.structuredData);
            Integer index = FilterVisitor.toInteger(seg.getElementId());
            if (index == null) {
                query.has(Constants.Property.__structuredDataKey.name(), seg.getElementId());
                continue;
            }
            Pipeline[] indexOrKey = new Pipeline[]{new HawkularPipeline().has(Constants.Property.__structuredDataIndex.name(), index).hasNot(Constants.Property.__structuredDataKey.name()), new HawkularPipeline().has(Constants.Property.__structuredDataKey.name(), seg.getElementId())};
            query.or((Pipe[])indexOrKey);
        }
    }

    public void visit(HawkularPipeline<?, ?> query, With.DataValued dataValue) {
        query.has(Constants.Property.__structuredDataValue.name(), dataValue.getValue());
    }

    public void visit(HawkularPipeline<?, ?> query, With.DataOfTypes dataTypes) {
        if (dataTypes.getTypes().length == 1) {
            query.has(Constants.Property.__structuredDataType.name(), dataTypes.getTypes()[0].name());
            return;
        }
        PropertyFilterPipe[] pipes = new PropertyFilterPipe[dataTypes.getTypes().length];
        for (int i = 0; i < pipes.length; ++i) {
            pipes[i] = new PropertyFilterPipe(Constants.Property.__structuredDataType.name(), (Predicate)Compare.EQUAL, (Object)dataTypes.getTypes()[i].name());
        }
        query.or((Pipe[])pipes);
    }

    private void convertToPipeline(RelativePath path, HawkularPipeline<?, ?> pipeline) {
        for (Path.Segment s : path.getPath()) {
            if (RelativePath.Up.class.equals((Object)s.getElementType())) {
                pipeline.in(new String[]{Relationships.WellKnown.contains.name()});
                continue;
            }
            pipeline.out(new String[]{Relationships.WellKnown.contains.name()});
            this.apply(s, pipeline);
        }
    }

    private void apply(Path.Segment segment, HawkularPipeline<?, ?> pipeline) {
        pipeline.hasType(Constants.Type.of(segment.getElementType()));
        pipeline.hasEid(segment.getElementId());
    }

    private static Integer toInteger(String str) {
        char[] chars = str.toCharArray();
        int result = 0;
        int multiplier = 1;
        int i = chars.length - 1;
        while (i >= 0) {
            char c = chars[i];
            if ('0' <= c && c <= '9') {
                result += (c - 48) * multiplier;
            } else {
                return null;
            }
            --i;
            multiplier *= 10;
        }
        return result;
    }
}

