/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Direction;
import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.blueprints.util.ElementHelper;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONMode;
import com.tinkerpop.blueprints.util.io.graphson.GraphSONWriter;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.PipeFunction;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Blueprint;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.DataEntity;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricDataType;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.StructuredData;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.base.spi.ShallowStructuredData;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;

final class TinkerpopBackend
implements InventoryBackend<Element> {
    private final InventoryContext<?> context;

    public TinkerpopBackend(InventoryContext<?> context) {
        this.context = context;
    }

    public InventoryBackend.Transaction startTransaction(boolean mutating) {
        return this.context.startTransaction(mutating);
    }

    public Element find(CanonicalPath element) throws ElementNotFoundException {
        HawkularPipeline<?, ? extends Element> q = this.translate(null, Query.to((CanonicalPath)element));
        if (!q.hasNext()) {
            throw new ElementNotFoundException();
        }
        return (Element)q.next();
    }

    public Page<Element> traverse(Element startingPoint, Query query, Pager pager) {
        HawkularPipeline<?, Element> q = this.translate(startingPoint, query);
        q.counter("total").page(pager);
        return new Page(q.cast(Element.class).toList(), (PageContext)pager, q.getCount("total"));
    }

    public Page<Element> query(Query query, Pager pager) {
        return this.traverse(null, query, pager);
    }

    private HawkularPipeline<?, ? extends Element> translate(Element startingPoint, Query query) {
        GremlinPipeline q = startingPoint != null ? new HawkularPipeline(startingPoint) : (query.getFragments()[0].getFilter() instanceof RelationFilter ? new HawkularPipeline(this.context.getGraph()).E() : new HawkularPipeline(this.context.getGraph()).V());
        FilterApplicator.applyAll(query, q);
        return q;
    }

    public <T> Page<T> query(Query query, Pager pager, Function<Element, T> conversion, Function<T, Boolean> filter) {
        GremlinPipeline q = query.getFragments()[0].getFilter() instanceof RelationFilter ? new HawkularPipeline(this.context.getGraph()).E() : new HawkularPipeline(this.context.getGraph()).V();
        FilterApplicator.applyAll(query, q);
        HawkularPipeline q2 = filter == null ? q.counter("total").page(pager).transform(conversion::apply) : q.transform(conversion::apply).filter(filter::apply).counter("total").page(pager, (e, p) -> {
            if (!(e instanceof AbstractElement)) {
                return null;
            }
            AbstractElement el = (AbstractElement)e;
            if ("id".equals(p)) {
                return el.getId();
            }
            return (Comparable)el.getProperties().get(p);
        });
        return new Page(q2.toList(), (PageContext)pager, q.getCount("total"));
    }

    public Iterator<Element> getTransitiveClosureOver(Element startingPoint, Relationships.Direction direction, String ... relationshipNames) {
        if (!(startingPoint instanceof Vertex)) {
            return Collections.emptyList().iterator();
        }
        GremlinPipeline ret = new HawkularPipeline(startingPoint).as("start");
        switch (direction) {
            case incoming: {
                ret.in(relationshipNames);
                break;
            }
            case outgoing: {
                ret.out(relationshipNames);
                break;
            }
            case both: {
                ret.both(relationshipNames);
            }
        }
        return ret.loop("start", x -> true, x -> true).toList().iterator();
    }

    public boolean hasRelationship(Element entity, Relationships.Direction direction, String relationshipName) {
        if (!(entity instanceof Vertex)) {
            return false;
        }
        return ((Vertex)entity).getEdges(TinkerpopBackend.toNative(direction), new String[]{relationshipName}).iterator().hasNext();
    }

    public boolean hasRelationship(Element source, Element target, String relationshipName) {
        if (!(source instanceof Vertex) || !(target instanceof Vertex)) {
            return false;
        }
        Iterator targets = ((Vertex)source).getVertices(Direction.OUT, new String[]{relationshipName}).iterator();
        while (targets.hasNext()) {
            if (!target.equals(targets.next())) continue;
            return true;
        }
        return false;
    }

    public Element getRelationship(Element source, Element target, String relationshipName) throws ElementNotFoundException {
        if (!(source instanceof Vertex) || !(target instanceof Vertex)) {
            throw new IllegalArgumentException("Source or target entity not a vertex.");
        }
        if (relationshipName == null) {
            throw new IllegalArgumentException("relationshipName == null");
        }
        Vertex t = (Vertex)target;
        GremlinPipeline it = new HawkularPipeline(source).outE(new String[]{relationshipName}).remember().inV().hasType(TinkerpopBackend.getType(t)).hasEid(TinkerpopBackend.getEid((Element)t)).recall().cast(Edge.class);
        if (!it.hasNext()) {
            throw new ElementNotFoundException();
        }
        return (Element)it.next();
    }

    public Set<Element> getRelationships(Element entity, Relationships.Direction direction, String ... names) {
        if (!(entity instanceof Vertex)) {
            return Collections.emptySet();
        }
        Vertex v = (Vertex)entity;
        HawkularPipeline q = new HawkularPipeline(v);
        switch (direction) {
            case incoming: {
                q.inE(names);
                break;
            }
            case outgoing: {
                q.outE(names);
                break;
            }
            case both: {
                q.bothE(names);
                break;
            }
            default: {
                throw new AssertionError((Object)("Invalid relationship direction specified: " + direction));
            }
        }
        return StreamSupport.stream(q.spliterator(), false).collect(Collectors.toSet());
    }

    public String extractRelationshipName(Element relationship) {
        return ((Edge)relationship).getLabel();
    }

    public Element getRelationshipSource(Element relationship) {
        return ((Edge)relationship).getVertex(Direction.OUT);
    }

    public Element getRelationshipTarget(Element relationship) {
        return ((Edge)relationship).getVertex(Direction.IN);
    }

    public String extractId(Element entityRepresentation) {
        return (String)entityRepresentation.getProperty(Constants.Property.__eid.name());
    }

    public Class<?> extractType(Element entityRepresentation) {
        if (entityRepresentation instanceof Edge) {
            return Relationship.class;
        }
        return TinkerpopBackend.getType((Vertex)entityRepresentation).getEntityType();
    }

    public CanonicalPath extractCanonicalPath(Element entityRepresentation) {
        String cp = (String)entityRepresentation.getProperty(Constants.Property.__cp.name());
        if (cp == null) {
            throw new IllegalArgumentException("Element is not representable using a canonical path. Element type is " + this.extractType(entityRepresentation).getSimpleName() + ", element id is '" + this.extractId(entityRepresentation) + "'.");
        }
        return CanonicalPath.fromString((String)cp);
    }

    public <T> T convert(Element entityRepresentation, final Class<T> entityType) {
        Environment e;
        Constants.Type type = Constants.Type.of(this.extractType(entityRepresentation));
        if (type == Constants.Type.relationship) {
            Edge edge = (Edge)entityRepresentation;
            CanonicalPath source = this.extractCanonicalPath((Element)edge.getVertex(Direction.OUT));
            CanonicalPath target = this.extractCanonicalPath((Element)edge.getVertex(Direction.IN));
            e = new Relationship(this.extractId((Element)edge), edge.getLabel(), source, target);
        } else {
            Vertex v = (Vertex)entityRepresentation;
            switch (type) {
                case environment: {
                    e = new Environment(this.extractCanonicalPath((Element)v));
                    break;
                }
                case feed: {
                    e = new Feed(this.extractCanonicalPath((Element)v));
                    break;
                }
                case metric: {
                    Vertex mdv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                    MetricType md = this.convert((Element)mdv, MetricType.class);
                    e = new Metric(this.extractCanonicalPath((Element)v), md);
                    break;
                }
                case metricType: {
                    e = new MetricType(this.extractCanonicalPath((Element)v), MetricUnit.fromDisplayName((String)((String)v.getProperty(Constants.Property.__unit.name()))), MetricDataType.fromDisplayName((String)((String)v.getProperty(Constants.Property.__metric_data_type.name()))));
                    break;
                }
                case resource: {
                    Vertex rtv = (Vertex)v.getVertices(Direction.IN, new String[]{Relationships.WellKnown.defines.name()}).iterator().next();
                    ResourceType rt = this.convert((Element)rtv, ResourceType.class);
                    e = new Resource(this.extractCanonicalPath((Element)v), rt);
                    break;
                }
                case resourceType: {
                    e = new ResourceType(this.extractCanonicalPath((Element)v));
                    break;
                }
                case tenant: {
                    e = new Tenant(this.extractCanonicalPath((Element)v));
                    break;
                }
                case structuredData: {
                    e = this.loadStructuredData(v, StructuredData.class.equals(entityType));
                    break;
                }
                case dataEntity: {
                    CanonicalPath cp = this.extractCanonicalPath((Element)v);
                    e = new DataEntity(cp.up(), DataEntity.Role.valueOf((String)cp.getSegment().getElementId()), this.loadStructuredData(v, Relationships.WellKnown.hasData));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown type of vertex");
                }
            }
        }
        List<String> mappedProps = Arrays.asList(type.getMappedProperties());
        final HashMap filteredProperties = new HashMap();
        entityRepresentation.getPropertyKeys().forEach(k -> {
            if (!mappedProps.contains(k)) {
                filteredProperties.put(k, entityRepresentation.getProperty(k));
            }
        });
        if (StructuredData.class.equals(entityType)) {
            return entityType.cast(e);
        }
        if (ShallowStructuredData.class.equals(entityType)) {
            return entityType.cast(new ShallowStructuredData((StructuredData)e));
        }
        AbstractElement el = (AbstractElement)e;
        return (T)el.accept((ElementVisitor)new ElementVisitor.Simple<T, Void>(){

            public T visitTenant(Tenant tenant, Void ignored) {
                return this.common((AbstractElement)tenant, (AbstractElement.Update.Builder)Tenant.Update.builder());
            }

            public T visitEnvironment(Environment environment, Void ignored) {
                return this.common((AbstractElement)environment, (AbstractElement.Update.Builder)Environment.Update.builder());
            }

            public T visitFeed(Feed feed, Void ignored) {
                return this.common((AbstractElement)feed, (AbstractElement.Update.Builder)Feed.Update.builder());
            }

            public T visitMetric(Metric metric, Void ignored) {
                return this.common((AbstractElement)metric, (AbstractElement.Update.Builder)Metric.Update.builder());
            }

            public T visitMetricType(MetricType metricType, Void ignored) {
                return this.common((AbstractElement)metricType, (AbstractElement.Update.Builder)MetricType.Update.builder());
            }

            public T visitResource(Resource resource, Void ignored) {
                return this.common((AbstractElement)resource, (AbstractElement.Update.Builder)Resource.Update.builder());
            }

            public T visitResourceType(ResourceType type, Void ignored) {
                return this.common((AbstractElement)type, (AbstractElement.Update.Builder)ResourceType.Update.builder());
            }

            public T visitData(DataEntity data, Void ignored) {
                return this.common((AbstractElement)data, (AbstractElement.Update.Builder)DataEntity.Update.builder());
            }

            public T visitRelationship(Relationship relationship, Void parameter) {
                return this.common((AbstractElement)relationship, (AbstractElement.Update.Builder)Relationship.Update.builder());
            }

            private <U extends AbstractElement.Update> T common(AbstractElement<?, U> entity, AbstractElement.Update.Builder<U, ?> bld) {
                return entityType.cast(entity.update().with(bld.withProperties(filteredProperties).build()));
            }
        }, null);
    }

    public Element descendToData(Element dataEntityRepresentation, RelativePath dataPath) {
        Query q = Query.path().with(new Filter[]{With.dataAt((RelativePath)dataPath)}).get();
        HawkularPipeline pipeline = new HawkularPipeline(dataEntityRepresentation);
        FilterApplicator.applyAll(q, pipeline);
        if (pipeline.hasNext()) {
            return (Element)pipeline.next();
        }
        return null;
    }

    public Element relate(Element sourceEntity, Element targetEntity, String name, Map<String, Object> properties) {
        if (name == null) {
            throw new IllegalArgumentException("name == null");
        }
        if (!(sourceEntity instanceof Vertex)) {
            throw new IllegalArgumentException("Source not a vertex.");
        }
        if (!(targetEntity instanceof Vertex)) {
            throw new IllegalArgumentException("Target not a vertex.");
        }
        Edge e = ((Vertex)sourceEntity).addEdge(name, (Vertex)targetEntity);
        if (properties != null) {
            ElementHelper.setProperties((Element)e, properties);
        }
        e.setProperty(Constants.Property.__eid.name(), (Object)e.getId().toString());
        e.setProperty(Constants.Property.__cp.name(), (Object)((CanonicalPath)CanonicalPath.of().relationship(e.getId().toString()).get()).toString());
        return e;
    }

    public Element persist(final CanonicalPath path, Blueprint blueprint) {
        return (Element)blueprint.accept((ElementBlueprintVisitor)new ElementBlueprintVisitor.Simple<Element, Void>(){

            public Element visitTenant(Tenant.Blueprint tenant, Void parameter) {
                return this.common(path, tenant.getProperties(), Tenant.class);
            }

            public Element visitEnvironment(Environment.Blueprint environment, Void parameter) {
                return this.common(path, environment.getProperties(), Environment.class);
            }

            public Element visitFeed(Feed.Blueprint feed, Void parameter) {
                return this.common(path, feed.getProperties(), Feed.class);
            }

            public Element visitMetric(Metric.Blueprint metric, Void parameter) {
                return this.common(path, metric.getProperties(), Metric.class);
            }

            public Element visitMetricType(MetricType.Blueprint definition, Void parameter) {
                Vertex entity = this.common(path, definition.getProperties(), MetricType.class);
                entity.setProperty(Constants.Property.__metric_data_type.name(), (Object)definition.getType().getDisplayName());
                return entity;
            }

            public Element visitResource(Resource.Blueprint resource, Void parameter) {
                return this.common(path, resource.getProperties(), Resource.class);
            }

            public Element visitResourceType(ResourceType.Blueprint type, Void parameter) {
                return this.common(path, type.getProperties(), ResourceType.class);
            }

            public Element visitRelationship(Relationship.Blueprint relationship, Void parameter) {
                throw new IllegalArgumentException("Relationships cannot be persisted using the persist() method.");
            }

            public Element visitData(DataEntity.Blueprint data, Void parameter) {
                return this.common(path, data.getProperties(), DataEntity.class);
            }

            private Vertex common(CanonicalPath path2, Map<String, Object> properties, Class<? extends AbstractElement<?, ?>> cls) {
                TinkerpopBackend.checkProperties(properties, Constants.Type.of(cls).getMappedProperties());
                Vertex v = TinkerpopBackend.this.context.getGraph().addVertex(null);
                v.setProperty(Constants.Property.__type.name(), (Object)Constants.Type.of(cls).name());
                v.setProperty(Constants.Property.__eid.name(), (Object)path2.getSegment().getElementId());
                v.setProperty(Constants.Property.__cp.name(), (Object)path2.toString());
                if (properties != null) {
                    ElementHelper.setProperties((Element)v, properties);
                }
                return v;
            }
        }, null);
    }

    public Vertex persist(StructuredData structuredData) {
        Vertex thisVertex = this.context.getGraph().addVertex(null);
        final Pair<Object, Vertex> parentAndCurrent = new Pair<Object, Vertex>(null, thisVertex);
        structuredData.accept((StructuredData.Visitor)new StructuredData.Visitor.Simple<Void, StructuredData>(){

            protected Void defaultAction(Serializable value, StructuredData data) {
                this.relateToParent();
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__type.name(), (Object)Constants.Type.structuredData.name());
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataType.name(), (Object)data.getType().name());
                if (value != null) {
                    ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataValue.name(), (Object)value);
                }
                return null;
            }

            public Void visitList(List<StructuredData> value, StructuredData data) {
                this.relateToParent();
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__type.name(), (Object)Constants.Type.structuredData.name());
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataType.name(), (Object)StructuredData.Type.list.name());
                Vertex currentParent = (Vertex)parentAndCurrent.first;
                Vertex currentCurrent = (Vertex)parentAndCurrent.second;
                parentAndCurrent.first = parentAndCurrent.second;
                int idx = 0;
                for (StructuredData c : value) {
                    parentAndCurrent.second = TinkerpopBackend.this.context.getGraph().addVertex(null);
                    ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataIndex.name(), (Object)idx++);
                    c.accept((StructuredData.Visitor)this, (Object)c);
                }
                parentAndCurrent.first = currentParent;
                parentAndCurrent.second = currentCurrent;
                return null;
            }

            public Void visitMap(Map<String, StructuredData> value, StructuredData data) {
                this.relateToParent();
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__type.name(), (Object)Constants.Type.structuredData.name());
                ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataType.name(), (Object)StructuredData.Type.map.name());
                Vertex currentParent = (Vertex)parentAndCurrent.first;
                Vertex currentCurrent = (Vertex)parentAndCurrent.second;
                parentAndCurrent.first = parentAndCurrent.second;
                int idx = 0;
                for (Map.Entry<String, StructuredData> e : value.entrySet()) {
                    parentAndCurrent.second = TinkerpopBackend.this.context.getGraph().addVertex(null);
                    ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataIndex.name(), (Object)idx++);
                    ((Vertex)parentAndCurrent.second).setProperty(Constants.Property.__structuredDataKey.name(), (Object)e.getKey());
                    e.getValue().accept((StructuredData.Visitor)this, (Object)e.getValue());
                }
                parentAndCurrent.first = currentParent;
                parentAndCurrent.second = currentCurrent;
                return null;
            }

            private void relateToParent() {
                if (parentAndCurrent.first != null) {
                    TinkerpopBackend.this.relate((Element)parentAndCurrent.first, (Element)parentAndCurrent.second, Relationships.WellKnown.contains.name(), null);
                }
            }
        }, (Object)structuredData);
        return thisVertex;
    }

    public void update(final Element entity, AbstractElement.Update update) {
        update.accept((ElementUpdateVisitor)new ElementUpdateVisitor.Simple<Void, Void>(){

            public Void visitTenant(Tenant.Update tenant, Void parameter) {
                this.common(tenant.getProperties(), Tenant.class);
                return null;
            }

            public Void visitEnvironment(Environment.Update environment, Void parameter) {
                this.common(environment.getProperties(), Environment.class);
                return null;
            }

            public Void visitFeed(Feed.Update feed, Void parameter) {
                this.common(feed.getProperties(), Feed.class);
                return null;
            }

            public Void visitMetric(Metric.Update metric, Void parameter) {
                this.common(metric.getProperties(), Metric.class);
                return null;
            }

            public Void visitMetricType(MetricType.Update definition, Void parameter) {
                this.common(definition.getProperties(), MetricType.class);
                if (definition.getUnit() != null) {
                    entity.setProperty(Constants.Property.__unit.name(), (Object)definition.getUnit().getDisplayName());
                }
                return null;
            }

            public Void visitResource(Resource.Update resource, Void parameter) {
                this.common(resource.getProperties(), Resource.class);
                return null;
            }

            public Void visitResourceType(ResourceType.Update type, Void parameter) {
                this.common(type.getProperties(), ResourceType.class);
                return null;
            }

            public Void visitRelationship(Relationship.Update relationship, Void parameter) {
                this.common(relationship.getProperties(), Relationship.class);
                return null;
            }

            public Void visitData(DataEntity.Update data, Void parameter) {
                this.common(data.getProperties(), DataEntity.class);
                Vertex v = (Vertex)entity;
                Vertex dataVertex = (Vertex)v.getVertices(Direction.OUT, new String[]{Relationships.WellKnown.hasData.name()}).iterator().next();
                Iterator<Element> children = TinkerpopBackend.this.getTransitiveClosureOver((Element)dataVertex, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name());
                while (children.hasNext()) {
                    Vertex c = (Vertex)children.next();
                    TinkerpopBackend.this.context.getGraph().removeVertex(c);
                }
                TinkerpopBackend.this.context.getGraph().removeVertex(dataVertex);
                Vertex newData = TinkerpopBackend.this.persist(data.getValue());
                TinkerpopBackend.this.relate((Element)v, (Element)newData, Relationships.WellKnown.hasData.name(), null);
                return null;
            }

            private void common(Map<String, Object> properties, Class<? extends AbstractElement<?, ?>> entityType) {
                Class<?> actualType = TinkerpopBackend.this.extractType(entity);
                if (!actualType.equals(entityType)) {
                    throw new IllegalArgumentException("Update object doesn't correspond to the actual type of the entity.");
                }
                String[] disallowedProperties = Constants.Type.of(entityType).getMappedProperties();
                TinkerpopBackend.checkProperties(properties, disallowedProperties);
                TinkerpopBackend.updateProperties(entity, properties, disallowedProperties);
            }
        }, null);
    }

    public void delete(Element entity) {
        entity.remove();
    }

    public void deleteStructuredData(Element dataRepresentation) {
        if (!StructuredData.class.equals(this.extractType(dataRepresentation))) {
            throw new IllegalArgumentException("The supplied element is not a data entity's data.");
        }
        Iterator<Element> dataElements = this.getTransitiveClosureOver(dataRepresentation, Relationships.Direction.outgoing, Relationships.WellKnown.contains.name());
        while (dataElements.hasNext()) {
            this.delete(dataElements.next());
        }
    }

    public void commit(InventoryBackend.Transaction t) throws CommitFailureException {
        try {
            this.context.commit(t);
        }
        catch (Exception e) {
            throw new CommitFailureException((Throwable)e);
        }
    }

    public void rollback(InventoryBackend.Transaction t) {
        this.context.rollback(t);
    }

    public void close() throws Exception {
        this.context.getGraph().shutdown();
    }

    private StructuredData loadStructuredData(Vertex owner, Relationships.WellKnown owningEdge) {
        Iterator it = owner.getVertices(Direction.OUT, new String[]{owningEdge.name()}).iterator();
        if (!it.hasNext()) {
            return null;
        }
        return this.loadStructuredData((Vertex)it.next(), true);
    }

    private StructuredData loadStructuredData(Vertex root, boolean recurse) {
        StructuredData.Type type = StructuredData.Type.valueOf((String)((String)root.getProperty(Constants.Property.__structuredDataType.name())));
        switch (type) {
            case bool: {
                return StructuredData.get().bool((Boolean)root.getProperty(Constants.Property.__structuredDataValue.name()));
            }
            case integral: {
                return StructuredData.get().integral((Long)root.getProperty(Constants.Property.__structuredDataValue.name()));
            }
            case floatingPoint: {
                return StructuredData.get().floatingPoint((Double)root.getProperty(Constants.Property.__structuredDataValue.name()));
            }
            case undefined: {
                return StructuredData.get().undefined();
            }
            case string: {
                return StructuredData.get().string((String)root.getProperty(Constants.Property.__structuredDataValue.name()));
            }
            case list: {
                StructuredData.ListBuilder lst = StructuredData.get().list();
                if (recurse) {
                    this.loadStructuredDataList(root, (StructuredData.AbstractListBuilder<?>)lst);
                }
                return lst.build();
            }
            case map: {
                StructuredData.MapBuilder mp = StructuredData.get().map();
                if (recurse) {
                    this.loadStructuredDataMap(root, (StructuredData.AbstractMapBuilder<?>)mp);
                }
                return mp.build();
            }
        }
        throw new IllegalArgumentException("Unknown structured data type stored in db: " + type);
    }

    private void loadStructuredDataList(Vertex root, StructuredData.AbstractListBuilder<?> bld) {
        PipeFunction orderFn = vs -> {
            Integer idxA = (Integer)((Vertex)vs.getA()).getProperty(Constants.Property.__structuredDataIndex.name());
            Integer idxB = (Integer)((Vertex)vs.getB()).getProperty(Constants.Property.__structuredDataIndex.name());
            return idxA - idxB;
        };
        block9: for (Vertex child : new HawkularPipeline(root).out(Relationships.WellKnown.contains).order(orderFn)) {
            StructuredData.Type type = StructuredData.Type.valueOf((String)((String)child.getProperty(Constants.Property.__structuredDataType.name())));
            switch (type) {
                case bool: {
                    bld.addBool(((Boolean)child.getProperty(Constants.Property.__structuredDataValue.name())).booleanValue());
                    continue block9;
                }
                case integral: {
                    bld.addIntegral(((Long)child.getProperty(Constants.Property.__structuredDataValue.name())).longValue());
                    continue block9;
                }
                case floatingPoint: {
                    bld.addFloatingPoint(((Double)child.getProperty(Constants.Property.__structuredDataValue.name())).doubleValue());
                    continue block9;
                }
                case undefined: {
                    bld.addUndefined();
                    continue block9;
                }
                case string: {
                    bld.addString((String)child.getProperty(Constants.Property.__structuredDataValue.name()));
                    continue block9;
                }
                case list: {
                    StructuredData.InnerListBuilder lst = bld.addList();
                    this.loadStructuredDataList(child, (StructuredData.AbstractListBuilder<?>)lst);
                    lst.closeList();
                    continue block9;
                }
                case map: {
                    StructuredData.InnerMapBuilder mp = bld.addMap();
                    this.loadStructuredDataMap(child, (StructuredData.AbstractMapBuilder<?>)mp);
                    mp.closeMap();
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown structured data type stored in db: " + type);
        }
    }

    private void loadStructuredDataMap(Vertex root, StructuredData.AbstractMapBuilder<?> bld) {
        PipeFunction orderFn = vs -> {
            Integer idxA = (Integer)((Vertex)vs.getA()).getProperty(Constants.Property.__structuredDataIndex.name());
            Integer idxB = (Integer)((Vertex)vs.getB()).getProperty(Constants.Property.__structuredDataIndex.name());
            return idxA - idxB;
        };
        block9: for (Vertex v : new HawkularPipeline(root).out(Relationships.WellKnown.contains).order(orderFn)) {
            String key = v.getProperty(Constants.Property.__structuredDataKey.name()).toString();
            String type = (String)v.getProperty(Constants.Property.__structuredDataType.name());
            switch (StructuredData.Type.valueOf((String)type)) {
                case bool: {
                    bld.putBool(key, ((Boolean)v.getProperty(Constants.Property.__structuredDataValue.name())).booleanValue());
                    continue block9;
                }
                case integral: {
                    bld.putIntegral(key, ((Long)v.getProperty(Constants.Property.__structuredDataValue.name())).longValue());
                    continue block9;
                }
                case floatingPoint: {
                    bld.putFloatingPoint(key, ((Double)v.getProperty(Constants.Property.__structuredDataValue.name())).doubleValue());
                    continue block9;
                }
                case undefined: {
                    bld.putUndefined(key);
                    continue block9;
                }
                case string: {
                    bld.putString(key, (String)v.getProperty(Constants.Property.__structuredDataValue.name()));
                    continue block9;
                }
                case list: {
                    StructuredData.InnerListBuilder lst = bld.putList(key);
                    this.loadStructuredDataList(v, (StructuredData.AbstractListBuilder<?>)lst);
                    lst.closeList();
                    continue block9;
                }
                case map: {
                    StructuredData.InnerMapBuilder mp = bld.putMap(key);
                    this.loadStructuredDataMap(v, (StructuredData.AbstractMapBuilder<?>)mp);
                    mp.closeMap();
                    continue block9;
                }
            }
            throw new IllegalArgumentException("Unknown structured data type stored in db: " + type);
        }
    }

    static void checkProperties(Map<String, Object> properties, String[] disallowedProperties) {
        if (properties == null || properties.isEmpty()) {
            return;
        }
        HashSet<String> disallowed = new HashSet<String>(properties.keySet());
        disallowed.retainAll(Arrays.asList(disallowedProperties));
        if (!disallowed.isEmpty()) {
            throw new IllegalArgumentException("The following properties are reserved for this type of entity: " + Arrays.asList(disallowedProperties));
        }
    }

    static void updateProperties(Element e, Map<String, Object> properties, String[] disallowedProperties) {
        String[] toRemove;
        if (properties == null) {
            return;
        }
        HashSet<String> disallowed = new HashSet<String>(Arrays.asList(disallowedProperties));
        for (String p2 : toRemove = (String[])e.getPropertyKeys().stream().filter(p -> !disallowed.contains(p) && !properties.containsKey(p)).toArray(String[]::new)) {
            e.removeProperty(p2);
        }
        properties.forEach((p, v) -> {
            if (!disallowed.contains(p)) {
                e.setProperty(p, v);
            }
        });
    }

    static Vertex getTenantVertexOf(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case environment: 
            case metricType: 
            case resourceType: {
                return (Vertex)entityVertex.getVertices(Direction.IN, new String[]{Relationships.WellKnown.contains.name()}).iterator().next();
            }
            case feed: 
            case metric: 
            case resource: {
                return TinkerpopBackend.getTenantVertexOf(TinkerpopBackend.getEnvironmentVertexOf(entityVertex));
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOf(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                return (Vertex)new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator().next();
            }
        }
        return null;
    }

    static Vertex getEnvironmentVertexOrNull(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case feed: 
            case metric: 
            case resource: {
                Iterator envs = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.environment).iterator();
                if (envs.hasNext()) {
                    return (Vertex)envs.next();
                }
                return null;
            }
        }
        return null;
    }

    static Vertex getFeedVertexOrNull(Vertex entityVertex) {
        Constants.Type type = TinkerpopBackend.getType(entityVertex);
        switch (type) {
            case metric: 
            case resource: {
                Iterator feeds = new HawkularPipeline(entityVertex).in(Relationships.WellKnown.contains).hasType(Constants.Type.feed).iterator();
                if (feeds.hasNext()) {
                    return (Vertex)feeds.next();
                }
                return null;
            }
        }
        return null;
    }

    static Constants.Type getType(Vertex v) {
        return Constants.Type.valueOf((String)v.getProperty(Constants.Property.__type.name()));
    }

    static String getEid(Element e) {
        return (String)e.getProperty(Constants.Property.__eid.name());
    }

    static Direction toNative(Relationships.Direction direction) {
        return direction == Relationships.Direction.incoming ? Direction.IN : (direction == Relationships.Direction.outgoing ? Direction.OUT : Direction.BOTH);
    }

    public InputStream getGraphSON(String tenantId) {
        PipedInputStream in = new PipedInputStream();
        new Thread(() -> {
            try (PipedOutputStream out = new PipedOutputStream(in);){
                GraphSONWriter.outputGraph((Graph)this.context.getGraph(), (OutputStream)out, (GraphSONMode)GraphSONMode.NORMAL);
            }
            catch (IOException e) {
                throw new IllegalStateException("Unable to create the GraphSON dump.", e);
            }
        }).start();
        return in;
    }

    private static final class Pair<F, S> {
        public F first;
        public S second;

        public Pair(F first, S second) {
            this.first = first;
            this.second = second;
        }
    }
}

