/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.TransactionalGraph;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.impl.tinkerpop.TinkerpopInventory;
import org.hawkular.inventory.impl.tinkerpop.spi.GraphProvider;

final class InventoryContext<G extends TransactionalGraph> {
    private final G graph;
    private final TinkerpopInventory inventory;
    private final GraphProvider<G> graphProvider;

    public InventoryContext(TinkerpopInventory inventory, G graph, GraphProvider<G> graphProvider) {
        this.inventory = inventory;
        this.graph = graph;
        this.graphProvider = graphProvider;
    }

    public TinkerpopInventory getInventory() {
        return this.inventory;
    }

    public TransactionalGraph getGraph() {
        return this.graph;
    }

    public InventoryBackend.Transaction startTransaction(boolean mutating) {
        return this.graphProvider.startTransaction(this.graph, mutating);
    }

    public void commit(InventoryBackend.Transaction t) {
        this.graphProvider.commit(this.graph, t);
    }

    public void rollback(InventoryBackend.Transaction t) {
        this.graphProvider.rollback(this.graph, t);
    }
}

