/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest;

import com.wordnik.swagger.annotations.Api;
import com.wordnik.swagger.annotations.ApiOperation;
import com.wordnik.swagger.annotations.ApiResponse;
import com.wordnik.swagger.annotations.ApiResponses;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.rest.RestBase;
import org.hawkular.inventory.rest.json.ApiError;

@Path(value="/path")
@Produces(value={"application/json"})
@Consumes(value={"application/json"})
@Api(value="/path", description="The endpoint to obtain inventory entities by their canonical path.")
public class RestPath
extends RestBase {
    @GET
    @Path(value="/{entityPath:.+}")
    @ApiOperation(value="Return an entity with the provided canonical path")
    @ApiResponses(value={@ApiResponse(code=200, message="The entity", response=Entity.class), @ApiResponse(code=401, message="Unauthorized access"), @ApiResponse(code=404, message="The entity doesn't exist", response=ApiError.class), @ApiResponse(code=500, message="Server error", response=ApiError.class)})
    public Response get(String entityPath) {
        String tenantId = this.getTenantId();
        CanonicalPath tenant = (CanonicalPath)CanonicalPath.of().tenant(tenantId).get();
        CanonicalPath path = CanonicalPath.fromPartiallyUntypedString((String)entityPath, (CanonicalPath)tenant, Entity.class);
        return Response.ok((Object)this.inventory.inspect(path, ResolvableToSingle.class).entity()).build();
    }
}

