/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.rest.json;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import org.hawkular.inventory.api.model.Relationship;

public class RelationshipJacksonSerializer
extends JsonSerializer<Relationship> {
    public static final String FIELD_ID = "id";
    public static final String FIELD_NAME = "name";
    public static final String FIELD_SOURCE = "source";
    public static final String FIELD_TARGET = "target";
    public static final String FIELD_PROPERTIES = "properties";

    public void serialize(Relationship relationship, JsonGenerator jg, SerializerProvider serializerProvider) throws IOException {
        jg.writeStartObject();
        jg.writeFieldName(FIELD_ID);
        jg.writeString(relationship.getId());
        jg.writeFieldName(FIELD_NAME);
        jg.writeString(relationship.getName());
        jg.writeFieldName(FIELD_SOURCE);
        jg.writeString(relationship.getSource().toString());
        jg.writeFieldName(FIELD_TARGET);
        jg.writeString(relationship.getTarget().toString());
        if (relationship.getProperties() != null && !relationship.getProperties().isEmpty()) {
            jg.writeFieldName(FIELD_PROPERTIES);
            jg.writeStartObject();
            for (Map.Entry property : relationship.getProperties().entrySet()) {
                jg.writeFieldName((String)property.getKey());
                jg.writeObject(property.getValue());
            }
            jg.writeEndObject();
        }
        jg.writeEndObject();
    }
}

