/*
 * Copyright 2015 Red Hat, Inc. and/or its affiliates
 * and other contributors as indicated by the @author tags.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.hawkular.inventory.api.filters;

import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Tenant;

/**
 * A helper class to create filters on the "contains" relationship. This can also be achieved by using the
 * {@link Related} filter.
 *
 * @author Lukas Krejci
 * @since 1.0
 */
public final class Contained<T extends Entity> extends Related<T> {

    private Contained(T entity) {
        super(entity, Relationships.WellKnown.contains.name(), EntityRole.TARGET);
    }

    public static Contained<Environment> in(Environment environment) {
        return new Contained<>(environment);
    }

    public static Contained<Tenant> in(Tenant tenant) {
        return new Contained<>(tenant);
    }
}
