/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EmptyInventory;
import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Tenant;

final class AutoTenantInventory
implements Inventory,
Inventory.Mixin.AutoTenant {
    private final Inventory inventory;

    public AutoTenantInventory(Inventory inventory) {
        this.inventory = inventory;
    }

    @Override
    public Tenants.ReadWrite tenants() {
        return new Tenants.ReadWrite(){

            @Override
            public Tenants.Single create(Tenant.Blueprint blueprint) throws EntityAlreadyExistsException {
                return (Tenants.Single)AutoTenantInventory.this.inventory.tenants().create(blueprint);
            }

            @Override
            public void update(String id, Tenant.Update update) throws EntityNotFoundException {
                AutoTenantInventory.this.inventory.tenants().update(id, update);
            }

            @Override
            public void delete(String id) throws EntityNotFoundException {
                AutoTenantInventory.this.inventory.tenants().delete(id);
            }

            @Override
            public Tenants.Single get(String id) throws EntityNotFoundException {
                Tenants.Single ret = (Tenants.Single)AutoTenantInventory.this.inventory.tenants().get(id);
                if (ret.exists()) {
                    return ret;
                }
                AutoTenantInventory.this.inventory.tenants().create(((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId(id)).build());
                return ret;
            }

            @Override
            public Tenants.Multiple getAll(Filter ... filters) {
                return new EmptyInventory.TenantsMultiple();
            }
        };
    }

    @Override
    public void initialize(Configuration configuration) {
        this.inventory.initialize(configuration);
    }

    @Override
    public void close() throws Exception {
        this.inventory.close();
    }
}

