/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Iterator;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.ObservableContext;
import org.hawkular.inventory.api.ObservableRelationships;
import org.hawkular.inventory.api.ReadInterface;
import org.hawkular.inventory.api.Relatable;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.WriteInterface;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import rx.subjects.Subject;

class ObservableBase<T> {
    protected final ObservableContext context;
    protected final T wrapped;

    ObservableBase(T wrapped, ObservableContext context) {
        this.context = context;
        this.wrapped = wrapped;
    }

    protected <V, I> I wrap(BiFunction<V, ObservableContext, I> constructor, V value) {
        return constructor.apply(value, this.context);
    }

    protected <C, E, V extends ResolvableToSingle<E>, I> I wrapAndNotify(BiFunction<V, ObservableContext, I> constructor, V value, Function<V, C> contextProducer, Action<C, E> action) {
        E e = value.entity();
        C c = contextProducer.apply(value);
        this.notify(e, c, action);
        return constructor.apply(value, this.context);
    }

    protected <E> void notify(E entity, Action<E, E> action) {
        this.notify(entity, entity, action);
    }

    protected <C, E> void notify(E entity, C actionContext, Action<C, E> action) {
        Iterator<Subject<C, C>> subjects = this.context.matchingSubjects(action, entity);
        while (subjects.hasNext()) {
            Subject<C, C> s = subjects.next();
            s.onNext(actionContext);
        }
    }

    public static abstract class RelatableMultiple<E, T extends Relatable<Relationships.Read> & ResolvableToMany<E>>
    extends MultipleBase<E, T> {
        RelatableMultiple(T wrapped, ObservableContext context) {
            super((ResolvableToMany)wrapped, context);
        }

        public ObservableRelationships.Read relationships() {
            return this.wrap(ObservableRelationships.Read::new, ((Relatable)this.wrapped).relationships());
        }

        public ObservableRelationships.Read relationships(Relationships.Direction direction) {
            return this.wrap(ObservableRelationships.Read::new, ((Relatable)this.wrapped).relationships(direction));
        }
    }

    public static abstract class RelatableSingle<E, T extends Relatable<Relationships.ReadWrite> & ResolvableToSingle<E>>
    extends SingleBase<E, T> {
        RelatableSingle(T wrapped, ObservableContext context) {
            super((ResolvableToSingle)wrapped, context);
        }

        public ObservableRelationships.ReadWrite relationships() {
            return this.wrap(ObservableRelationships.ReadWrite::new, ((Relatable)this.wrapped).relationships());
        }

        public ObservableRelationships.ReadWrite relationships(Relationships.Direction direction) {
            return this.wrap(ObservableRelationships.ReadWrite::new, ((Relatable)this.wrapped).relationships(direction));
        }
    }

    public static abstract class MultipleBase<E, T extends ResolvableToMany<E>>
    extends ObservableBase<T> {
        MultipleBase(T wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        public Page<E> entities(Pager pager) {
            return ((ResolvableToMany)this.wrapped).entities(pager);
        }
    }

    public static abstract class SingleBase<E, T extends ResolvableToSingle<E>>
    extends ObservableBase<T> {
        SingleBase(T wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        public E entity() throws EntityNotFoundException, RelationNotFoundException {
            return (E)((ResolvableToSingle)this.wrapped).entity();
        }
    }

    public static abstract class ReadWrite<E extends AbstractElement<B, U>, B extends Entity.Blueprint, U extends AbstractElement.Update, Single extends ResolvableToSingle<E> & Relatable<Relationships.ReadWrite>, Multiple extends ResolvableToMany<E>, Iface extends ReadInterface<Single, Multiple> & WriteInterface<U, B, Single>>
    extends ObservableBase<Iface> {
        ReadWrite(Iface wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        protected abstract BiFunction<Single, ObservableContext, ? extends Single> singleCtor();

        protected abstract BiFunction<Multiple, ObservableContext, ? extends Multiple> multipleCtor();

        public Single get(String id) {
            return (Single)((ResolvableToSingle)this.wrap(this.singleCtor(), ((ReadInterface)this.wrapped).get(id)));
        }

        public Multiple getAll(Filter ... filters) {
            return (Multiple)((ResolvableToMany)this.wrap(this.multipleCtor(), ((ReadInterface)this.wrapped).getAll(filters)));
        }

        public Single create(B b) {
            ResolvableToSingle s = (ResolvableToSingle)((WriteInterface)((Object)((ReadInterface)this.wrapped))).create(b);
            AbstractElement e = (AbstractElement)s.entity();
            this.notify(e, e, Action.created());
            ((Relationships.Multiple)((Relationships.ReadWrite)((Relatable)((Object)s)).relationships(Relationships.Direction.both)).getAll(new RelationFilter[0])).entities().forEach(r -> this.notify(r, r, Action.created()));
            return (Single)((ResolvableToSingle)this.wrap(this.singleCtor(), s));
        }

        public void update(String id, U u) {
            AbstractElement e = (AbstractElement)((ResolvableToSingle)((ReadInterface)this.wrapped).get(id)).entity();
            ((WriteInterface)((Object)((ReadInterface)this.wrapped))).update(id, u);
            this.notify(e, new Action.Update<AbstractElement, U>(e, u), Action.updated());
        }

        public void delete(String id) {
            AbstractElement e = (AbstractElement)this.get(id).entity();
            ((WriteInterface)((Object)((ReadInterface)this.wrapped))).delete(id);
            this.notify(e, e, Action.deleted());
        }
    }

    public static abstract class Read<Single extends ResolvableToSingle<?>, Multiple extends ResolvableToMany<?>, Iface extends ReadInterface<Single, Multiple>>
    extends ObservableBase<Iface> {
        Read(Iface wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        protected abstract BiFunction<Single, ObservableContext, ? extends Single> singleCtor();

        protected abstract BiFunction<Multiple, ObservableContext, ? extends Multiple> multipleCtor();

        public Single get(String id) {
            return (Single)((ResolvableToSingle)this.wrap(this.singleCtor(), ((ReadInterface)this.wrapped).get(id)));
        }

        public Multiple getAll(Filter ... filters) {
            return (Multiple)((ResolvableToMany)this.wrap(this.multipleCtor(), ((ReadInterface)this.wrapped).getAll(filters)));
        }
    }

    public static abstract class ReadMultiple<Multiple extends ResolvableToMany<?>, Iface extends ResolvingToMultiple<Multiple>>
    extends ObservableBase<Iface> {
        ReadMultiple(Iface wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        protected abstract BiFunction<Multiple, ObservableContext, ? extends Multiple> multipleCtor();

        public Multiple getAll(Filter ... filters) {
            return (Multiple)((ResolvableToMany)this.wrap(this.multipleCtor(), ((ResolvingToMultiple)this.wrapped).getAll(filters)));
        }
    }
}

