/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.function.BiFunction;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ObservableBase;
import org.hawkular.inventory.api.ObservableContext;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Relationship;

final class ObservableMetrics {
    private ObservableMetrics() {
    }

    static final class Multiple
    extends ObservableBase.RelatableMultiple<Metric, Metrics.Multiple>
    implements Metrics.Multiple {
        Multiple(Metrics.Multiple wrapped, ObservableContext context) {
            super(wrapped, context);
        }
    }

    static final class Single
    extends ObservableBase.RelatableSingle<Metric, Metrics.Single>
    implements Metrics.Single {
        Single(Metrics.Single wrapped, ObservableContext context) {
            super(wrapped, context);
        }
    }

    static final class ReadWrite
    extends ObservableBase.ReadWrite<Metric, Metric.Blueprint, Metric.Update, Metrics.Single, Metrics.Multiple, Metrics.ReadWrite>
    implements Metrics.ReadWrite {
        ReadWrite(Metrics.ReadWrite wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Metrics.Single, ObservableContext, ? extends Metrics.Single> singleCtor() {
            return Single::new;
        }

        @Override
        protected BiFunction<Metrics.Multiple, ObservableContext, ? extends Metrics.Multiple> multipleCtor() {
            return Multiple::new;
        }
    }

    static final class ReadAssociate
    extends ObservableBase.Read<Metrics.Single, Metrics.Multiple, Metrics.ReadAssociate>
    implements Metrics.ReadAssociate {
        ReadAssociate(Metrics.ReadAssociate wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Metrics.Single, ObservableContext, ? extends Metrics.Single> singleCtor() {
            return Single::new;
        }

        @Override
        protected BiFunction<Metrics.Multiple, ObservableContext, ? extends Metrics.Multiple> multipleCtor() {
            return Multiple::new;
        }

        @Override
        public Relationship associate(String id) {
            Relationship ret = ((Metrics.ReadAssociate)this.wrapped).associate(id);
            this.notify(ret, Action.created());
            return ret;
        }

        @Override
        public Relationship disassociate(String id) {
            Relationship ret = ((Metrics.ReadAssociate)this.wrapped).disassociate(id);
            this.notify(ret, Action.deleted());
            return ret;
        }

        @Override
        public Relationship associationWith(String id) throws RelationNotFoundException {
            return ((Metrics.ReadAssociate)this.wrapped).associationWith(id);
        }
    }

    static final class Read
    extends ObservableBase.Read<Metrics.Single, Metrics.Multiple, Metrics.Read>
    implements Metrics.Read {
        Read(Metrics.Read wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Metrics.Single, ObservableContext, ? extends Metrics.Single> singleCtor() {
            return Single::new;
        }

        @Override
        protected BiFunction<Metrics.Multiple, ObservableContext, ? extends Metrics.Multiple> multipleCtor() {
            return Multiple::new;
        }
    }

    static final class ReadMultiple
    extends ObservableBase.ReadMultiple<Metrics.Multiple, ResolvingToMultiple<Metrics.Multiple>>
    implements ResolvingToMultiple<Metrics.Multiple> {
        ReadMultiple(ResolvingToMultiple<Metrics.Multiple> wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Metrics.Multiple, ObservableContext, ? extends Metrics.Multiple> multipleCtor() {
            return Multiple::new;
        }
    }
}

