/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.google.gson.annotations.Expose;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import javax.xml.bind.annotation.XmlAttribute;

public abstract class AbstractElement<B, U extends Update> {
    public static final String ID_PROPERTY = "id";
    @XmlAttribute
    @Expose
    protected final String id;
    @Expose
    protected final Map<String, Object> properties;

    AbstractElement() {
        this.id = null;
        this.properties = null;
    }

    AbstractElement(String id, Map<String, Object> properties) {
        if (id == null) {
            throw new IllegalArgumentException("id == null");
        }
        this.id = id;
        if (properties == null) {
            this.properties = null;
        } else {
            this.properties = new HashMap<String, Object>(properties);
            this.properties.remove(ID_PROPERTY);
        }
    }

    public String getId() {
        return this.id;
    }

    public Map<String, Object> getProperties() {
        if (this.properties == null) {
            return Collections.emptyMap();
        }
        return this.properties;
    }

    protected static <T> T valueOrDefault(T value, T defaultValue) {
        return value == null ? defaultValue : value;
    }

    public abstract Updater<U, ? extends AbstractElement<?, U>> update();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractElement entity = (AbstractElement)o;
        return this.id.equals(entity.id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    public static final class Updater<U extends Update, E extends AbstractElement<?, U>> {
        private final Function<U, E> updater;

        Updater(Function<U, E> updater) {
            this.updater = updater;
        }

        public E with(U update) {
            return (E)((AbstractElement)this.updater.apply(update));
        }
    }

    public static abstract class Update {
        private final Map<String, Object> properties;

        public Update(Map<String, Object> properties) {
            this.properties = properties == null ? null : Collections.unmodifiableMap(new HashMap<String, Object>(properties));
        }

        public Map<String, Object> getProperties() {
            if (this.properties == null) {
                return Collections.emptyMap();
            }
            return this.properties;
        }

        public static abstract class Builder<U extends Update, This extends Builder<U, This>> {
            protected final Map<String, Object> properties = new HashMap<String, Object>();

            public This withProperty(String key, Object value) {
                this.properties.put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.properties.putAll(properties);
                return this.castThis();
            }

            public abstract U build();

            protected This castThis() {
                return (This)this;
            }
        }
    }
}

