/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.EntityVisitor;

public abstract class Entity<B extends Blueprint, U extends AbstractElement.Update>
extends AbstractElement<B, U> {
    Entity() {
    }

    Entity(String id) {
        this(id, null);
    }

    Entity(String id, Map<String, Object> properties) {
        super(id, properties);
    }

    public abstract <R, P> R accept(EntityVisitor<R, P> var1, P var2);

    protected void appendToString(StringBuilder toStringBuilder) {
    }

    public final String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[id='").append(this.getId()).append('\'');
        this.appendToString(bld);
        bld.append(']');
        return bld.toString();
    }

    public static abstract class Blueprint {
        @XmlAttribute
        private final String id;
        @XmlElement
        private final Map<String, Object> properties;

        protected Blueprint(String id, Map<String, Object> properties) {
            this.id = id;
            this.properties = properties;
        }

        public String getId() {
            return this.id;
        }

        public Map<String, Object> getProperties() {
            return this.properties;
        }

        public static abstract class Builder<B, This extends Builder<B, This>> {
            protected String id;
            protected Map<String, Object> properties = new HashMap<String, Object>();

            public This withId(String id) {
                this.id = id;
                return this.castThis();
            }

            public This withProperty(String key, Object value) {
                this.properties.put(key, value);
                return this.castThis();
            }

            public This withProperties(Map<String, Object> properties) {
                this.properties.putAll(properties);
                return this.castThis();
            }

            public abstract B build();

            protected This castThis() {
                return (This)this;
            }
        }
    }
}

