/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

public enum MetricUnit {
    NONE(""),
    MILLI_SECOND("ms"),
    SECONDS("s"),
    MINUTE("min"),
    BYTE("b"),
    KILO_BYTE("kb");

    private final String displayName;

    private MetricUnit(String displayName) {
        this.displayName = displayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public static MetricUnit fromDisplayName(String displayName) {
        for (MetricUnit mu : MetricUnit.values()) {
            if (!mu.displayName.equals(displayName)) continue;
            return mu;
        }
        throw new IllegalArgumentException("No such unit: " + displayName);
    }
}

