/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.FeedBasedEntity;
import org.hawkular.inventory.api.model.ResourceType;

@XmlRootElement
public final class Resource
extends FeedBasedEntity<Blueprint, Update> {
    @Expose
    private final ResourceType type;

    private Resource() {
        this.type = null;
    }

    public Resource(String tenantId, String environmentId, String feedId, String id, ResourceType type) {
        super(tenantId, environmentId, feedId, id);
        this.type = type;
    }

    @JsonCreator
    public Resource(@JsonProperty(value="tenant") String tenantId, @JsonProperty(value="environment") String environmentId, @JsonProperty(value="feed") String feedId, @JsonProperty(value="id") String id, @JsonProperty(value="type") ResourceType type, @JsonProperty(value="properties") Map<String, Object> properties) {
        super(tenantId, environmentId, feedId, id, properties);
        this.type = type;
    }

    @Override
    public AbstractElement.Updater<Update, Resource> update() {
        return new AbstractElement.Updater<Update, Resource>(u -> new Resource(this.getTenantId(), this.getEnvironmentId(), this.getFeedId(), this.getId(), this.getType(), u.getProperties()));
    }

    public ResourceType getType() {
        return this.type;
    }

    @Override
    public <R, P> R accept(EntityVisitor<R, P> visitor, P parameter) {
        return visitor.visitResource(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", type=").append(this.type);
    }

    public static final class Update
    extends AbstractElement.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(properties);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        private final String resourceTypeId;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this(null, null, null);
        }

        public Blueprint(String id, String resourceTypeId) {
            this(id, resourceTypeId, Collections.emptyMap());
        }

        public Blueprint(String id, String resourceTypeId, Map<String, Object> properties) {
            super(id, properties);
            this.resourceTypeId = resourceTypeId;
        }

        public String getResourceTypeId() {
            return this.resourceTypeId;
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String resourceTypeId;

            public Builder withResourceType(String resourceTypeId) {
                this.resourceTypeId = resourceTypeId;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.resourceTypeId, this.properties);
            }
        }
    }
}

