/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.TenantBasedEntity;

@XmlRootElement
public final class ResourceType
extends TenantBasedEntity<Blueprint, Update> {
    @XmlAttribute
    @Expose
    private final String version;

    private ResourceType() {
        this.version = null;
    }

    public ResourceType(String tenantId, String id, String version) {
        super(tenantId, id);
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        this.version = version;
    }

    @JsonCreator
    public ResourceType(@JsonProperty(value="tenant") String tenantId, @JsonProperty(value="id") String id, @JsonProperty(value="version") String version, @JsonProperty(value="properties") Map<String, Object> properties) {
        super(tenantId, id, properties);
        if (version == null) {
            throw new IllegalArgumentException("version == null");
        }
        this.version = version;
    }

    @Override
    public AbstractElement.Updater<Update, ResourceType> update() {
        return new AbstractElement.Updater<Update, ResourceType>(u -> new ResourceType(this.getTenantId(), this.getId(), ((Update)u).version == null ? this.version : ((Update)u).version, u.getProperties()));
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        ResourceType that = (ResourceType)o;
        return this.version.equals(that.version);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.version.hashCode();
        return result;
    }

    @Override
    public <R, P> R accept(EntityVisitor<R, P> visitor, P parameter) {
        return visitor.visitResourceType(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", version=").append(this.version);
    }

    public static final class Update
    extends AbstractElement.Update {
        private final String version;

        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null, null);
        }

        public Update(Map<String, Object> properties, String version) {
            super(properties);
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            private String version;

            public Builder withVersion(String version) {
                this.version = version;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.properties, this.version);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        @XmlAttribute
        private final String version;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this(null, null, null);
        }

        public Blueprint(String id, String version) {
            this(id, version, Collections.emptyMap());
        }

        public Blueprint(String id, String version, Map<String, Object> properties) {
            super(id, properties);
            this.version = version;
        }

        public String getVersion() {
            return this.version;
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private String version;

            public Builder withVersion(String version) {
                this.version = version;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.version, this.properties);
            }
        }
    }
}

