/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;

public abstract class TenantBasedEntity<B extends Entity.Blueprint, U extends AbstractElement.Update>
extends Entity<B, U> {
    @XmlAttribute(name="tenant")
    @Expose
    private final String tenantId;

    TenantBasedEntity() {
        this.tenantId = null;
    }

    TenantBasedEntity(String tenantId, String id) {
        super(id);
        if (tenantId == null) {
            throw new IllegalArgumentException("tenantId == null");
        }
        this.tenantId = tenantId;
    }

    TenantBasedEntity(String tenantId, String id, Map<String, Object> properties) {
        super(id, properties);
        this.tenantId = tenantId;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        TenantBasedEntity entity = (TenantBasedEntity)o;
        return this.tenantId.equals(entity.tenantId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.tenantId.hashCode();
        return result;
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", tenantId='").append(this.tenantId).append("'");
    }
}

