/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.ObservableContext;
import org.hawkular.inventory.api.ObservableTenants;
import rx.Observable;

final class ObservableInventory
implements Inventory,
Inventory.Mixin.Observable {
    private final Inventory inventory;
    private final ObservableContext context;

    ObservableInventory(Inventory inventory) {
        this.inventory = inventory;
        this.context = new ObservableContext();
    }

    @Override
    public void initialize(Configuration configuration) {
        this.inventory.initialize(configuration);
    }

    @Override
    public ObservableTenants.ReadWrite tenants() {
        return new ObservableTenants.ReadWrite(this.inventory.tenants(), this.context);
    }

    @Override
    public void close() throws Exception {
        this.inventory.close();
    }

    @Override
    public <C, E> Observable<C> observable(Interest<C, E> interest) {
        return this.context.getObservableFor(interest);
    }

    @Override
    public boolean hasObservers(Interest<?, ?> interest) {
        return this.context.isObserved(interest);
    }
}

