/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Map;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.ObservableBase;
import org.hawkular.inventory.api.ObservableContext;
import org.hawkular.inventory.api.ObservableEnvironments;
import org.hawkular.inventory.api.ObservableFeeds;
import org.hawkular.inventory.api.ObservableMetricTypes;
import org.hawkular.inventory.api.ObservableMetrics;
import org.hawkular.inventory.api.ObservableResourceTypes;
import org.hawkular.inventory.api.ObservableResources;
import org.hawkular.inventory.api.ObservableTenants;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Relationship;

final class ObservableRelationships {
    ObservableRelationships() {
    }

    static final class Multiple
    extends ObservableBase.MultipleBase<Relationship, Relationships.Multiple>
    implements Relationships.Multiple {
        Multiple(Relationships.Multiple wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        public ObservableTenants.Read tenants() {
            return this.wrap(ObservableTenants.Read::new, ((Relationships.Multiple)this.wrapped).tenants());
        }

        @Override
        public ObservableEnvironments.Read environments() {
            return this.wrap(ObservableEnvironments.Read::new, ((Relationships.Multiple)this.wrapped).environments());
        }

        @Override
        public ObservableFeeds.Read feeds() {
            return this.wrap(ObservableFeeds.Read::new, ((Relationships.Multiple)this.wrapped).feeds());
        }

        @Override
        public ObservableMetricTypes.Read metricTypes() {
            return this.wrap(ObservableMetricTypes.Read::new, ((Relationships.Multiple)this.wrapped).metricTypes());
        }

        @Override
        public ObservableMetrics.Read metrics() {
            return this.wrap(ObservableMetrics.Read::new, ((Relationships.Multiple)this.wrapped).metrics());
        }

        @Override
        public ObservableResources.Read resources() {
            return this.wrap(ObservableResources.Read::new, ((Relationships.Multiple)this.wrapped).resources());
        }

        @Override
        public ObservableResourceTypes.Read resourceTypes() {
            return this.wrap(ObservableResourceTypes.Read::new, ((Relationships.Multiple)this.wrapped).resourceTypes());
        }
    }

    static final class Single
    extends ObservableBase.SingleBase<Relationship, Relationships.Single>
    implements Relationships.Single {
        Single(Relationships.Single wrapped, ObservableContext context) {
            super(wrapped, context);
        }
    }

    static final class Read
    extends ObservableBase<Relationships.Read>
    implements Relationships.Read {
        Read(Relationships.Read wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        public Relationships.Multiple named(String name) {
            return this.wrap(Multiple::new, ((Relationships.Read)this.wrapped).named(name));
        }

        @Override
        public Relationships.Multiple named(Relationships.WellKnown name) {
            return this.wrap(Multiple::new, ((Relationships.Read)this.wrapped).named(name));
        }

        @Override
        public Relationships.Single get(String id) throws EntityNotFoundException, RelationNotFoundException {
            return this.wrap(Single::new, ((Relationships.Read)this.wrapped).get(id));
        }

        @Override
        public Relationships.Multiple getAll(RelationFilter ... filters) {
            return this.wrap(Multiple::new, ((Relationships.Read)this.wrapped).getAll(filters));
        }
    }

    static final class ReadWrite
    extends ObservableBase<Relationships.ReadWrite>
    implements Relationships.ReadWrite {
        ReadWrite(Relationships.ReadWrite wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        public Relationships.Multiple named(String name) {
            return this.wrap(Multiple::new, ((Relationships.ReadWrite)this.wrapped).named(name));
        }

        @Override
        public Relationships.Multiple named(Relationships.WellKnown name) {
            return this.wrap(Multiple::new, ((Relationships.ReadWrite)this.wrapped).named(name));
        }

        @Override
        public Relationships.Single get(String id) throws EntityNotFoundException, RelationNotFoundException {
            return this.wrap(Single::new, ((Relationships.ReadWrite)this.wrapped).get(id));
        }

        @Override
        public Relationships.Multiple getAll(RelationFilter ... filters) {
            return this.wrap(Multiple::new, ((Relationships.ReadWrite)this.wrapped).getAll(filters));
        }

        @Override
        public Relationships.Single linkWith(String name, Entity targetOrSource, Map<String, String> properties) throws IllegalArgumentException {
            return this.wrapAndNotify(Single::new, (ResolvableToSingle)((Relationships.ReadWrite)this.wrapped).linkWith(name, targetOrSource, null), ResolvableToSingle::entity, Action.created());
        }

        @Override
        public Relationships.Single linkWith(Relationships.WellKnown name, Entity targetOrSource, Map<String, String> properties) throws IllegalArgumentException {
            return this.linkWith(name.name(), targetOrSource, (Map)null);
        }

        @Override
        public void update(String id, Relationship.Update update) throws RelationNotFoundException {
            Relationship r = (Relationship)((Relationships.Single)((Relationships.ReadWrite)this.wrapped).get(id)).entity();
            ((Relationships.ReadWrite)this.wrapped).update(id, update);
            this.notify(r, new Action.Update<Relationship, Relationship.Update>(r, update), Action.updated());
        }

        @Override
        public void delete(String id) throws RelationNotFoundException {
            Relationship r = (Relationship)this.get(id).entity();
            ((Relationships.ReadWrite)this.wrapped).delete(id);
            this.notify(r, Action.deleted());
        }
    }
}

