/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.Arrays;
import org.hawkular.inventory.api.InventoryException;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.Entity;

public final class RelationNotFoundException
extends InventoryException {
    private final String sourceEntityType;
    private final Filter[][] filters;
    private final String nameOrId;

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[] filters, String message, Throwable cause) {
        this(sourceEntityType, nameOrId, RelationNotFoundException.oneElem(filters), message, cause);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[][] filters, String message, Throwable cause) {
        super(message, cause);
        this.sourceEntityType = sourceEntityType != null ? sourceEntityType.getSimpleName() : null;
        this.filters = filters;
        this.nameOrId = nameOrId;
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, String nameOrId, Filter[] filters, Throwable cause) {
        this(sourceEntityType, nameOrId, filters, null, cause);
    }

    public RelationNotFoundException(String nameOrId, Filter[] filters, String message) {
        this(null, nameOrId, filters, message, null);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, Filter[] filters) {
        this(sourceEntityType, null, filters, null, null);
    }

    public RelationNotFoundException(Class<? extends Entity> sourceEntityType, Filter[][] filters) {
        this(sourceEntityType, null, filters, null, null);
    }

    public RelationNotFoundException(String nameOrId, Filter[] filters) {
        this(null, nameOrId, filters, null, null);
    }

    public RelationNotFoundException(String nameOrId, Filter[][] filters) {
        this(null, nameOrId, filters, null, null);
    }

    @Override
    public String getMessage() {
        return "Relation" + (this.sourceEntityType != null ? " with source in " + this.sourceEntityType : "") + (this.nameOrId != null ? " with name or id '" + this.nameOrId + "'" : "") + (this.filters != null ? " searched for using any of the filters: " + Arrays.deepToString((Object[])this.filters) : "") + (super.getMessage() == null ? ": Was not found." : ": " + super.getMessage());
    }

    private static Filter[][] oneElem(Filter[] elem) {
        Filter[][] ret = new Filter[][]{elem};
        return ret;
    }
}

