/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;

public abstract class Filter {
    private static final Filter[] EMPTY = new Filter[0];

    public static Accumulator by(Filter ... filters) {
        return new Accumulator(filters);
    }

    public static Filter[] all() {
        return EMPTY;
    }

    public static Filter[] pathTo(Entity<?, ?> entity) {
        return entity.accept(new EntityVisitor<Accumulator, Accumulator>(){

            @Override
            public Accumulator visitTenant(Tenant tenant, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(tenant.getId()));
            }

            @Override
            public Accumulator visitEnvironment(Environment environment, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(environment.getTenantId())).and((Filter)With.type(Environment.class)).and((Filter)With.id(environment.getId()));
            }

            @Override
            public Accumulator visitFeed(Feed feed, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(feed.getTenantId())).and((Filter)With.type(Environment.class)).and((Filter)With.id(feed.getEnvironmentId())).and((Filter)With.type(Feed.class)).and((Filter)With.id(feed.getId()));
            }

            @Override
            public Accumulator visitMetric(Metric metric, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(metric.getTenantId())).and((Filter)With.type(Environment.class)).and((Filter)With.id(metric.getEnvironmentId())).and((Filter)With.type(Metric.class)).and((Filter)With.id(metric.getId()));
            }

            @Override
            public Accumulator visitMetricType(MetricType type, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(type.getTenantId())).and((Filter)With.type(MetricType.class)).and((Filter)With.id(type.getId()));
            }

            @Override
            public Accumulator visitResource(Resource resource, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(resource.getTenantId())).and((Filter)With.type(Environment.class)).and((Filter)With.id(resource.getEnvironmentId())).and((Filter)With.type(Resource.class)).and((Filter)With.id(resource.getId()));
            }

            @Override
            public Accumulator visitResourceType(ResourceType type, Accumulator acc) {
                return acc.and((Filter)With.type(Tenant.class)).and((Filter)With.id(type.getTenantId())).and((Filter)With.type(ResourceType.class)).and((Filter)With.id(type.getId()));
            }
        }, Filter.by(new Filter[0])).get();
    }

    public static final class Accumulator {
        private final List<Filter> filters = new ArrayList<Filter>();

        private Accumulator(Filter ... fs) {
            for (Filter filter : fs) {
                this.filters.add(filter);
            }
        }

        public Accumulator and(Filter f) {
            this.filters.add(f);
            return this;
        }

        public Accumulator and(Filter ... fs) {
            Collections.addAll(this.filters, fs);
            return this;
        }

        public Filter[] get() {
            return this.filters.toArray(new Filter[this.filters.size()]);
        }
    }
}

