/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.gson.annotations.Expose;
import java.util.Collections;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.TenantBasedEntity;

@XmlRootElement
public final class MetricType
extends TenantBasedEntity<Blueprint, Update> {
    @XmlAttribute
    @Expose
    private final MetricUnit unit;

    private MetricType() {
        this.unit = null;
    }

    public MetricType(String tenantId, String id) {
        super(tenantId, id);
        this.unit = MetricUnit.NONE;
    }

    public MetricType(String tenantId, String id, MetricUnit unit) {
        super(tenantId, id);
        this.unit = unit;
    }

    @JsonCreator
    public MetricType(@JsonProperty(value="tenant") String tenantId, @JsonProperty(value="id") String id, @JsonProperty(value="unit") MetricUnit unit, @JsonProperty(value="properties") Map<String, Object> properties) {
        super(tenantId, id, properties);
        this.unit = unit;
    }

    public MetricUnit getUnit() {
        return this.unit;
    }

    @Override
    public AbstractElement.Updater<Update, MetricType> update() {
        return new AbstractElement.Updater<Update, MetricType>(u -> new MetricType(this.getTenantId(), this.getId(), MetricType.valueOrDefault(((Update)u).unit, this.unit), u.getProperties()));
    }

    @Override
    public <R, P> R accept(EntityVisitor<R, P> visitor, P parameter) {
        return visitor.visitMetricType(this, parameter);
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", unit=").append((Object)this.unit);
    }

    public static final class Update
    extends AbstractElement.Update {
        private final MetricUnit unit;

        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null, null);
        }

        public Update(Map<String, Object> properties, MetricUnit unit) {
            super(properties);
            this.unit = unit;
        }

        public MetricUnit getUnit() {
            return this.unit;
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            private MetricUnit unit;

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            @Override
            public Update build() {
                return new Update(this.properties, this.unit);
            }
        }
    }

    @XmlRootElement
    public static final class Blueprint
    extends Entity.Blueprint {
        @XmlAttribute
        private final MetricUnit unit;

        public static Builder builder() {
            return new Builder();
        }

        private Blueprint() {
            this(null, null, null);
        }

        public Blueprint(String id, MetricUnit unit) {
            this(id, unit, Collections.emptyMap());
        }

        public Blueprint(String id, MetricUnit unit, Map<String, Object> properties) {
            super(id, properties);
            this.unit = unit;
        }

        public MetricUnit getUnit() {
            return this.unit;
        }

        public static final class Builder
        extends Entity.Blueprint.Builder<Blueprint, Builder> {
            private MetricUnit unit;

            public Builder withUnit(MetricUnit unit) {
                this.unit = unit;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.id, this.unit, this.properties);
            }
        }
    }
}

