/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;

@XmlRootElement
public final class Relationship
extends AbstractElement<Void, Update> {
    @XmlAttribute
    @Expose
    private final String name;
    @Expose
    private final Entity source;
    @Expose
    private final Entity target;

    private Relationship() {
        this(null, null, null, null, null);
    }

    public Relationship(String id, String name, Entity source, Entity target) {
        this(id, name, source, target, null);
    }

    public Relationship(String id, String name, Entity source, Entity target, Map<String, Object> properties) {
        super(id, properties);
        this.name = name;
        this.source = source;
        this.target = target;
    }

    @Override
    public AbstractElement.Updater<Update, Relationship> update() {
        return new AbstractElement.Updater<Update, Relationship>(u -> new Relationship(this.getId(), this.getName(), this.getSource(), this.getTarget(), u.getProperties()));
    }

    public String getName() {
        return this.name;
    }

    public Entity getSource() {
        return this.source;
    }

    public Entity getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[id='").append(this.id).append('\'');
        bld.append(", name='").append(this.name).append('\'');
        bld.append(", source=").append(this.source);
        bld.append(" --").append(this.name).append("--> ");
        bld.append(" target=").append(this.target);
        bld.append(']');
        return bld.toString();
    }

    public static final class Update
    extends AbstractElement.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(properties);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }
}

