/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.ResultFilter;

public final class Configuration {
    private final FeedIdStrategy feedIdStrategy;
    private final Map<String, String> implementationConfiguration;
    private final ResultFilter resultFilter;

    public static Builder builder() {
        return new Builder();
    }

    public Configuration(FeedIdStrategy feedIdStrategy, ResultFilter resultFilter, Map<String, String> implementationConfiguration) {
        this.feedIdStrategy = feedIdStrategy;
        this.resultFilter = resultFilter;
        this.implementationConfiguration = implementationConfiguration;
    }

    public FeedIdStrategy getFeedIdStrategy() {
        return this.feedIdStrategy;
    }

    public ResultFilter getResultFilter() {
        return this.resultFilter;
    }

    public Map<String, String> getImplementationConfiguration() {
        return this.implementationConfiguration;
    }

    public static final class Builder {
        private FeedIdStrategy strategy;
        private ResultFilter resultFilter;
        private Map<String, String> configuration = new HashMap<String, String>();

        private Builder() {
        }

        public Builder withFeedIdStrategy(FeedIdStrategy strategy) {
            this.strategy = strategy;
            return this;
        }

        public Builder withResultFilter(ResultFilter resultFilter) {
            this.resultFilter = resultFilter;
            return this;
        }

        public Builder withConfiguration(Map<String, String> configuration) {
            this.configuration = configuration;
            return this;
        }

        public Builder withConfiguration(Properties properties) {
            HashMap<String, String> map = new HashMap<String, String>();
            properties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> map.put(k.toString(), v.toString())));
            return this.withConfiguration(map);
        }

        public Builder addConfigurationProperty(String key, String value) {
            this.configuration.put(key, value);
            return this;
        }

        public Configuration build() {
            return new Configuration(this.strategy, this.resultFilter, this.configuration);
        }
    }
}

