/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import org.hawkular.inventory.api.AutoTenantInventory;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ObservableInventory;
import org.hawkular.inventory.api.ObservableTenants;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import rx.Observable;

public interface Inventory
extends AutoCloseable {
    public static Mixin augment(Inventory inventory) {
        return new Mixin(inventory);
    }

    public static Mixin.ObservableMixin augment(Mixin.Observable inventory) {
        return new Mixin.ObservableMixin(inventory);
    }

    public static Mixin.AutoTenantMixin augment(Mixin.AutoTenant inventory) {
        return new Mixin.AutoTenantMixin(inventory);
    }

    public void initialize(Configuration var1);

    public Tenants.ReadWrite tenants();

    default public Tenants.Single inspect(Tenant tenant) throws EntityNotFoundException {
        return (Tenants.Single)this.tenants().get(tenant.getId());
    }

    default public Environments.Single inspect(Environment environment) throws EntityNotFoundException {
        return (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(environment.getTenantId())).environments()).get(environment.getId());
    }

    default public Feeds.Single inspect(Feed feed) throws EntityNotFoundException {
        return (Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(feed.getTenantId())).environments()).get(feed.getEnvironmentId())).feeds()).get(feed.getId());
    }

    default public Metrics.Single inspect(Metric metric) throws EntityNotFoundException {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(metric.getTenantId())).environments()).get(metric.getEnvironmentId());
        if (metric.getFeedId() == null) {
            return (Metrics.Single)((Metrics.ReadWrite)env.feedlessMetrics()).get(metric.getId());
        }
        return (Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(metric.getFeedId())).metrics()).get(metric.getId());
    }

    default public MetricTypes.Single inspect(MetricType metricType) throws EntityNotFoundException {
        return (MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.tenants().get(metricType.getId())).metricTypes()).get(metricType.getId());
    }

    default public Resources.Single inspect(Resource resource) throws EntityNotFoundException {
        Environments.Single env = (Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.tenants().get(resource.getTenantId())).environments()).get(resource.getEnvironmentId());
        if (resource.getFeedId() == null) {
            return (Resources.Single)((Resources.ReadWrite)env.feedlessResources()).get(resource.getId());
        }
        return (Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)env.feeds()).get(resource.getFeedId())).resources()).get(resource.getId());
    }

    default public ResourceTypes.Single inspect(ResourceType resourceType) throws EntityNotFoundException {
        return (ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.tenants().get(resourceType.getTenantId())).resourceTypes()).get(resourceType.getId());
    }

    default public <E extends Entity<?, ?>, Single extends ResolvableToSingle<E>> Single inspect(E entity, final Class<Single> accessInterface) {
        return (Single)((ResolvableToSingle)entity.accept(new EntityVisitor<Single, Void>(){

            @Override
            public Single visitTenant(Tenant tenant, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(tenant));
            }

            @Override
            public Single visitEnvironment(Environment environment, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(environment));
            }

            @Override
            public Single visitFeed(Feed feed, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(feed));
            }

            @Override
            public Single visitMetric(Metric metric, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(metric));
            }

            @Override
            public Single visitMetricType(MetricType definition, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(definition));
            }

            @Override
            public Single visitResource(Resource resource, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(resource));
            }

            @Override
            public Single visitResourceType(ResourceType type, Void ignored) {
                return (ResolvableToSingle)accessInterface.cast(Inventory.this.inspect(type));
            }
        }, null));
    }

    public static final class Mixin {
        private final Inventory inventory;

        private Mixin(Inventory inventory) {
            this.inventory = inventory;
        }

        public AutoTenantMixin autoTenant() {
            return new AutoTenantMixin(this.inventory);
        }

        public ObservableMixin observable() {
            return new ObservableMixin(this.inventory);
        }

        private static final class ObservableAutoTenantInventory
        implements AutoTenantAndObservable {
            private final ObservableInventory inventory;

            public ObservableAutoTenantInventory(AutoTenant inventory) {
                this.inventory = new ObservableInventory(inventory);
            }

            @Override
            public boolean hasObservers(Interest<?, ?> interest) {
                return this.inventory.hasObservers(interest);
            }

            @Override
            public void close() throws Exception {
                this.inventory.close();
            }

            @Override
            public void initialize(Configuration configuration) {
                this.inventory.initialize(configuration);
            }

            @Override
            public <C, E> rx.Observable<C> observable(Interest<C, E> interest) {
                return this.inventory.observable(interest);
            }

            @Override
            public ObservableTenants.ReadWrite tenants() {
                return this.inventory.tenants();
            }
        }

        private static final class AutoTenantObservableInventory
        implements AutoTenantAndObservable {
            private final Observable inventory;
            private final AutoTenantInventory autoTenant;

            public AutoTenantObservableInventory(Observable inventory) {
                this.inventory = inventory;
                this.autoTenant = new AutoTenantInventory(inventory);
            }

            @Override
            public void initialize(Configuration configuration) {
                this.autoTenant.initialize(configuration);
            }

            @Override
            public Tenants.ReadWrite tenants() {
                return this.autoTenant.tenants();
            }

            @Override
            public void close() throws Exception {
                this.autoTenant.close();
            }

            @Override
            public boolean hasObservers(Interest<?, ?> interest) {
                return this.inventory.hasObservers(interest);
            }

            @Override
            public <C, E> rx.Observable<C> observable(Interest<C, E> interest) {
                return this.inventory.observable(interest);
            }
        }

        public static interface AutoTenantAndObservable
        extends AutoTenant,
        Observable {
        }

        public static interface AutoTenant
        extends Inventory {
        }

        public static interface Observable
        extends Inventory {
            public boolean hasObservers(Interest<?, ?> var1);

            public <C, E> rx.Observable<C> observable(Interest<C, E> var1);
        }

        public static final class ObservableAndAutoTenantMixin {
            private final AutoTenantAndObservable inventory;

            private ObservableAndAutoTenantMixin(Observable inventory) {
                this.inventory = new AutoTenantObservableInventory(inventory);
            }

            private ObservableAndAutoTenantMixin(AutoTenant inventory) {
                this.inventory = new ObservableAutoTenantInventory(inventory);
            }

            public AutoTenantAndObservable get() {
                return this.inventory;
            }
        }

        public static final class AutoTenantMixin {
            private final AutoTenant inventory;

            private AutoTenantMixin(Inventory inventory) {
                this.inventory = new AutoTenantInventory(inventory);
            }

            private AutoTenantMixin(AutoTenant inventory) {
                this.inventory = inventory;
            }

            public ObservableAndAutoTenantMixin observable() {
                return new ObservableAndAutoTenantMixin(this.inventory);
            }

            public AutoTenant get() {
                return this.inventory;
            }
        }

        public static final class ObservableMixin {
            private final Observable inventory;

            private ObservableMixin(Inventory inventory) {
                this.inventory = new ObservableInventory(inventory);
            }

            private ObservableMixin(Observable inventory) {
                this.inventory = inventory;
            }

            public ObservableAndAutoTenantMixin autoTenant() {
                return new ObservableAndAutoTenantMixin(this.inventory);
            }

            public Observable get() {
                return this.inventory;
            }
        }
    }
}

