/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api;

import java.util.function.BiFunction;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.ObservableBase;
import org.hawkular.inventory.api.ObservableContext;
import org.hawkular.inventory.api.ObservableFeeds;
import org.hawkular.inventory.api.ObservableMetrics;
import org.hawkular.inventory.api.ObservableResources;
import org.hawkular.inventory.api.ResolvingToMultiple;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.model.Environment;

final class ObservableEnvironments {
    private ObservableEnvironments() {
    }

    static final class Multiple
    extends ObservableBase.RelatableMultiple<Environment, Environments.Multiple>
    implements Environments.Multiple {
        Multiple(Environments.Multiple wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        public ObservableFeeds.Read feeds() {
            return this.wrap(ObservableFeeds.Read::new, ((Environments.Multiple)this.wrapped).feeds());
        }

        @Override
        public ObservableResources.Read feedlessResources() {
            return this.wrap(ObservableResources.Read::new, ((Environments.Multiple)this.wrapped).feedlessResources());
        }

        @Override
        public ObservableMetrics.Read feedlessMetrics() {
            return this.wrap(ObservableMetrics.Read::new, ((Environments.Multiple)this.wrapped).feedlessMetrics());
        }

        @Override
        public ResolvingToMultiple<Metrics.Multiple> allMetrics() {
            return this.wrap(ObservableMetrics.ReadMultiple::new, ((Environments.Multiple)this.wrapped).allMetrics());
        }

        @Override
        public ResolvingToMultiple<Resources.Multiple> allResources() {
            return this.wrap(ObservableResources.ReadMultiple::new, ((Environments.Multiple)this.wrapped).allResources());
        }
    }

    static final class Single
    extends ObservableBase.RelatableSingle<Environment, Environments.Single>
    implements Environments.Single {
        Single(Environments.Single wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        public ObservableFeeds.ReadWrite feeds() {
            return this.wrap(ObservableFeeds.ReadWrite::new, ((Environments.Single)this.wrapped).feeds());
        }

        @Override
        public ObservableResources.ReadWrite feedlessResources() {
            return this.wrap(ObservableResources.ReadWrite::new, ((Environments.Single)this.wrapped).feedlessResources());
        }

        @Override
        public ObservableMetrics.ReadWrite feedlessMetrics() {
            return this.wrap(ObservableMetrics.ReadWrite::new, ((Environments.Single)this.wrapped).feedlessMetrics());
        }

        @Override
        public ResolvingToMultiple<Metrics.Multiple> allMetrics() {
            return this.wrap(ObservableMetrics.ReadMultiple::new, ((Environments.Single)this.wrapped).allMetrics());
        }

        @Override
        public ResolvingToMultiple<Resources.Multiple> allResources() {
            return this.wrap(ObservableResources.ReadMultiple::new, ((Environments.Single)this.wrapped).allResources());
        }
    }

    static final class ReadWrite
    extends ObservableBase.ReadWrite<Environment, Environment.Blueprint, Environment.Update, Environments.Single, Environments.Multiple, Environments.ReadWrite>
    implements Environments.ReadWrite {
        ReadWrite(Environments.ReadWrite wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Environments.Single, ObservableContext, ? extends Environments.Single> singleCtor() {
            return Single::new;
        }

        @Override
        protected BiFunction<Environments.Multiple, ObservableContext, ? extends Environments.Multiple> multipleCtor() {
            return Multiple::new;
        }

        @Override
        public void copy(String sourceEnvironmentId, String targetEnvironmentId) {
            ((Environments.ReadWrite)this.wrapped).copy(sourceEnvironmentId, targetEnvironmentId);
            Environment s = (Environment)((Environments.Single)this.get(sourceEnvironmentId)).entity();
            Environment t = (Environment)((Environments.Single)this.get(targetEnvironmentId)).entity();
            this.notify(t, Action.created());
            this.notify(s, new Action.EnvironmentCopy(s, t), Action.copied());
        }
    }

    static final class Read
    extends ObservableBase.Read<Environments.Single, Environments.Multiple, Environments.Read>
    implements Environments.Read {
        Read(Environments.Read wrapped, ObservableContext context) {
            super(wrapped, context);
        }

        @Override
        protected BiFunction<Environments.Single, ObservableContext, ? extends Environments.Single> singleCtor() {
            return Single::new;
        }

        @Override
        protected BiFunction<Environments.Multiple, ObservableContext, ? extends Environments.Multiple> multipleCtor() {
            return Multiple::new;
        }
    }
}

