/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.feeds;

import org.hawkular.inventory.api.EntityAlreadyExistsException;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.model.Feed;

public final class AcceptWithFallbackFeedIdStrategy
implements FeedIdStrategy {
    private final FeedIdStrategy fallback;

    public AcceptWithFallbackFeedIdStrategy() {
        this(null);
    }

    public AcceptWithFallbackFeedIdStrategy(FeedIdStrategy fallback) {
        this.fallback = fallback;
    }

    @Override
    public String generate(Inventory inventory, Feed proposedFeed) throws EntityAlreadyExistsException {
        try {
            ((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)inventory.tenants().get(proposedFeed.getTenantId())).environments()).get(proposedFeed.getEnvironmentId())).feeds()).get(proposedFeed.getId())).entity();
            if (this.fallback == null) {
                throw new EntityAlreadyExistsException(proposedFeed);
            }
            return this.fallback.generate(inventory, proposedFeed);
        }
        catch (EntityNotFoundException e) {
            return proposedFeed.getId();
        }
    }
}

