/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.TenantBasedEntity;

public abstract class EnvironmentBasedEntity<B extends Entity.Blueprint, U extends AbstractElement.Update>
extends TenantBasedEntity<B, U> {
    @XmlAttribute(name="environment")
    @Expose
    private final String environmentId;

    EnvironmentBasedEntity() {
        this.environmentId = null;
    }

    EnvironmentBasedEntity(String tenantId, String environmentId, String id) {
        super(tenantId, id);
        if (environmentId == null) {
            throw new IllegalArgumentException("environmentId == null");
        }
        this.environmentId = environmentId;
    }

    EnvironmentBasedEntity(String tenantId, String environmentId, String id, Map<String, Object> properties) {
        super(tenantId, id, properties);
        this.environmentId = environmentId;
    }

    public String getEnvironmentId() {
        return this.environmentId;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!super.equals(o)) {
            return false;
        }
        EnvironmentBasedEntity that = (EnvironmentBasedEntity)o;
        return this.environmentId.equals(that.environmentId);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.environmentId.hashCode();
        return result;
    }

    @Override
    protected void appendToString(StringBuilder toStringBuilder) {
        super.appendToString(toStringBuilder);
        toStringBuilder.append(", environmentId='").append(this.environmentId).append('\'');
    }
}

