/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.test;

import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.FeedAlreadyRegisteredException;
import org.hawkular.inventory.api.FeedIdStrategy;
import org.hawkular.inventory.api.Feeds;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.Resources;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.api.feeds.AcceptWithFallbackFeedIdStrategy;
import org.hawkular.inventory.api.feeds.RandomUUIDFeedIdStrategy;
import org.hawkular.inventory.api.filters.Defined;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.RelationFilter;
import org.hawkular.inventory.api.filters.RelationWith;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.MetricUnit;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.PathFragment;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.QueryFragment;
import org.hawkular.inventory.base.spi.CanonicalPath;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import rx.Subscription;

public abstract class AbstractBaseInventoryPersistenceCheck<E> {
    protected BaseInventory<E> inventory;

    protected abstract BaseInventory<E> instantiateNewInventory();

    protected abstract void destroyStorage() throws Exception;

    @Before
    public void setup() throws Exception {
        Properties ps = new Properties();
        try (FileInputStream f = new FileInputStream(System.getProperty("graph.config"));){
            ps.load(f);
        }
        Configuration config = Configuration.builder().withFeedIdStrategy((FeedIdStrategy)new AcceptWithFallbackFeedIdStrategy((FeedIdStrategy)new RandomUUIDFeedIdStrategy())).withConfiguration(ps).build();
        this.inventory = this.instantiateNewInventory();
        this.inventory.initialize(config);
        try {
            this.inventory.tenants().delete("com.acme.tenant");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.inventory.tenants().delete("com.example.tenant");
        }
        catch (Exception ignored) {
            // empty catch block
        }
        try {
            this.inventory.tenants().delete("perf0");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setupData();
    }

    private void setupData() throws Exception {
        assert (((Tenant)((Tenants.Single)this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("com.acme.tenant")).withProperty("kachny", (Object)"moc")).build())).entity()).getId().equals("com.acme.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).create((Entity.Blueprint)new Environment.Blueprint("production"))).entity()).getId().equals("production"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).resourceTypes()).create((Entity.Blueprint)new ResourceType.Blueprint("URL", "1.0"))).entity()).getId().equals("URL"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).metricTypes()).create((Entity.Blueprint)new MetricType.Blueprint("ResponseTime", MetricUnit.MILLI_SECOND))).entity()).getId().equals("ResponseTime"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).resourceTypes()).get("URL")).metricTypes()).associate("ResponseTime");
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feedlessMetrics()).create((Entity.Blueprint)new Metric.Blueprint("ResponseTime", "host1_ping_response"))).entity()).getId().equals("host1_ping_response"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feedlessResources()).create((Entity.Blueprint)new Resource.Blueprint("host1", "URL"))).entity()).getId().equals("host1"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feedlessResources()).get("host1")).metrics()).associate("host1_ping_response");
        assert (((Feed)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds()).create(new Feed.Blueprint("feed1", null)).entity()).getId().equals("feed1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds()).get("feed1")).resources()).create((Entity.Blueprint)new Resource.Blueprint("feedResource1", "URL"))).entity()).getId().equals("feedResource1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds()).get("feed1")).resources()).create((Entity.Blueprint)new Resource.Blueprint("feedResource2", "URL"))).entity()).getId().equals("feedResource2"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds()).get("feed1")).resources()).create((Entity.Blueprint)new Resource.Blueprint("feedResource3", "URL"))).entity()).getId().equals("feedResource3"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Feeds.Single)((Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds()).get("feed1")).metrics()).create((Entity.Blueprint)new Metric.Blueprint("ResponseTime", "feedMetric1"))).entity()).getId().equals("feedMetric1"));
        assert (((Tenant)((Tenants.Single)this.inventory.tenants().create((Entity.Blueprint)new Tenant.Blueprint("com.example.tenant"))).entity()).getId().equals("com.example.tenant"));
        assert (((Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).create((Entity.Blueprint)new Environment.Blueprint("test"))).entity()).getId().equals("test"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).create((Entity.Blueprint)new ResourceType.Blueprint("Kachna", "1.0"))).entity()).getId().equals("Kachna"));
        assert (((ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).create((Entity.Blueprint)new ResourceType.Blueprint("Playroom", "1.0"))).entity()).getId().equals("Playroom"));
        assert (((MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).metricTypes()).create((Entity.Blueprint)new MetricType.Blueprint("Size", MetricUnit.BYTE))).entity()).getId().equals("Size"));
        ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).get("Playroom")).metricTypes()).associate("Size");
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessMetrics()).create((Entity.Blueprint)new Metric.Blueprint("Size", "playroom1_size"))).entity()).getId().equals("playroom1_size"));
        assert (((Metric)((Metrics.Single)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessMetrics()).create((Entity.Blueprint)new Metric.Blueprint("Size", "playroom2_size"))).entity()).getId().equals("playroom2_size"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).create((Entity.Blueprint)new Resource.Blueprint("playroom1", "Playroom"))).entity()).getId().equals("playroom1"));
        assert (((Resource)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).create((Entity.Blueprint)new Resource.Blueprint("playroom2", "Playroom"))).entity()).getId().equals("playroom2"));
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom1")).metrics()).associate("playroom1_size");
        ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).associate("playroom2_size");
        Environment test = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).entity();
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).linkWith("yourMom", (Entity)test, null);
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.incoming)).linkWith("IamYourFather", (Entity)test, (Map)new HashMap<String, Object>(){
            {
                this.put("adult", true);
            }
        });
    }

    private void teardownData() throws Exception {
        Tenant t = new Tenant("com.example.tenant");
        Environment e = new Environment(t.getId(), "test");
        MetricType sizeType = new MetricType(t.getId(), "Size");
        ResourceType playRoomType = new ResourceType(t.getId(), "Playroom", "1.0");
        ResourceType kachnaType = new ResourceType(t.getId(), "Kachna", "1.0");
        Resource playroom1 = new Resource(t.getId(), e.getId(), null, "playroom1", playRoomType);
        Resource playroom2 = new Resource(t.getId(), e.getId(), null, "playroom2", playRoomType);
        Metric playroom1Size = new Metric(t.getId(), e.getId(), null, "playroom1_size", sizeType);
        Metric playroom2Size = new Metric(t.getId(), e.getId(), null, "playroom2_size", sizeType);
        ((Metrics.ReadWrite)this.inventory.inspect(e).feedlessMetrics()).delete(playroom2Size.getId());
        this.assertDoesNotExist((Entity)playroom2Size);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, kachnaType, playroom1, playroom2, playroom1Size});
        ((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).delete(kachnaType.getId());
        this.assertDoesNotExist((Entity)kachnaType);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2, playroom1Size});
        try {
            ((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).delete(sizeType.getId());
            Assert.fail((String)"Deleting a metric type which references some metrics should not be possible.");
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        ((Metrics.ReadWrite)this.inventory.inspect(e).feedlessMetrics()).delete(playroom1Size.getId());
        this.assertDoesNotExist((Entity)playroom1Size);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom1, playroom2});
        ((MetricTypes.ReadWrite)this.inventory.inspect(t).metricTypes()).delete(sizeType.getId());
        this.assertDoesNotExist((Entity)sizeType);
        this.assertExists(new Entity[]{t, e, playRoomType, playroom1, playroom2});
        try {
            ((ResourceTypes.ReadWrite)this.inventory.inspect(t).resourceTypes()).delete(playRoomType.getId());
            Assert.fail((String)"Deleting a resource type which references some resources should not be possible.");
        }
        catch (IllegalArgumentException ignored) {
            // empty catch block
        }
        ((Resources.ReadWrite)this.inventory.inspect(e).feedlessResources()).delete(playroom1.getId());
        this.assertDoesNotExist((Entity)playroom1);
        this.assertExists(new Entity[]{t, e, sizeType, playRoomType, playroom2});
        this.inventory.tenants().delete(t.getId());
        this.assertDoesNotExist((Entity)t);
        this.assertDoesNotExist((Entity)e);
        this.assertDoesNotExist((Entity)playRoomType);
        this.assertDoesNotExist((Entity)playroom2);
    }

    private void assertDoesNotExist(Entity e) {
        try {
            this.inventory.inspect(e, ResolvableToSingle.class).entity();
            Assert.fail((String)(e + " should have been deleted"));
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    private void assertExists(Entity e) {
        try {
            this.inventory.inspect(e, ResolvableToSingle.class);
        }
        catch (EntityNotFoundException ignored) {
            Assert.fail((String)(e + " should have been present in the inventory."));
        }
    }

    private void assertExists(Entity ... es) {
        Stream.of(es).forEach(this::assertExists);
    }

    @After
    public void teardown() throws Exception {
        try {
            this.teardownData();
        }
        finally {
            try {
                this.inventory.close();
            }
            finally {
                this.destroyStorage();
            }
        }
    }

    @Test
    public void testTenants() throws Exception {
        Function<String, Void> test = id -> {
            Query query = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)id)})).build();
            Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertEquals((long)1L, (long)results.size());
            Object tenant = results.get(0);
            String eid = this.inventory.getBackend().extractId(tenant);
            Assert.assertEquals((Object)id, (Object)eid);
            return null;
        };
        test.apply("com.acme.tenant");
        test.apply("com.example.tenant");
        Query query = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Tenant.class))}).build();
        Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
        Assert.assertEquals((long)2L, (long)results.size());
    }

    @Test
    public void testEntitiesByRelationships() throws Exception {
        Function<Integer, Function> testHelper = numberOfParents -> parentType -> edgeLabel -> numberOfKids -> childType -> multipleParents -> multipleChildren -> {
            InventoryBackend backend = this.inventory.getBackend();
            Page parents = backend.query(Query.path().with(new Filter[]{With.type((Class)parentType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Page children = backend.query(Query.path().with(new Filter[]{With.type((Class)parentType), Related.by((String)edgeLabel), With.type((Class)childType)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            assert (parents.size() == numberOfParents.intValue()) : "There must be exactly " + numberOfParents + " " + parentType + "s " + "that have outgoing edge labeled with " + edgeLabel + ". Backend " + "query returned only " + parents.size();
            assert (multipleParents.entities().size() == numberOfParents.intValue()) : "There must be exactly " + numberOfParents + " " + parentType + "s that have outgoing edge labeled with " + edgeLabel + ". Tested API returned only " + multipleParents.entities().size();
            assert (children.size() == numberOfKids.intValue()) : "There must be exactly " + numberOfKids + " " + childType + "s that are directly under " + parentType + " connected with " + edgeLabel + ". Gremlin query returned only " + children.size();
            assert (multipleChildren.entities().size() == numberOfKids.intValue());
        };
        ResolvableToMany parents = (ResolvableToMany)this.inventory.tenants().getAll(new Filter[]{Related.by((String)"contains")});
        ResolvableToMany kids = (ResolvableToMany)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(2)).apply(Environment.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((ResourceTypes.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).resourceTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(3)).apply(ResourceType.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((MetricTypes.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).metricTypes()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Tenant.class)).apply("contains")).apply(2)).apply(MetricType.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.by((String)"contains")});
        kids = (ResolvableToMany)((Metrics.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(3)).apply(Metric.class)).apply(parents)).accept(kids);
        kids = (ResolvableToMany)((Resources.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessResources()).getAll(new Filter[]{Related.asTargetBy((String)"contains")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(Environment.class)).apply("contains")).apply(3)).apply(Resource.class)).apply(parents)).accept(kids);
        parents = (ResolvableToMany)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[]{Related.by((String)"contains")});
        kids = (ResolvableToMany)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).allMetrics().getAll(new Filter[]{Related.asTargetBy((String)"defines")});
        ((Consumer)((Function)((Function)((Function)((Function)testHelper.apply(2).apply(MetricType.class)).apply("defines")).apply(4)).apply(Metric.class)).apply(parents)).accept(kids);
    }

    @Test
    public void testRelationshipServiceNamed1() throws Exception {
        Set contains = ((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getId()) && "URL".equals(rel.getTarget().getId()))) : "Tenant 'com.acme.tenant' must contain ResourceType 'URL'.";
        assert (contains.stream().anyMatch(rel -> "com.acme.tenant".equals(rel.getSource().getId()) && "production".equals(rel.getTarget().getId()))) : "Tenant 'com.acme.tenant' must contain Environment 'production'.";
        assert (contains.stream().anyMatch(rel -> "com.example.tenant".equals(rel.getSource().getId()) && "Size".equals(rel.getTarget().getId()))) : "Tenant 'com.example.tenant' must contain MetricType 'Size'.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceNamed2() throws Exception {
        Set contains = ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).named("contains").entities();
        assert (contains.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getId()))) : "Environment 'test' must contain 'playroom1'.";
        assert (contains.stream().anyMatch(rel -> "playroom2".equals(rel.getTarget().getId()))) : "Environment 'test' must contain 'playroom2'.";
        assert (contains.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getId()))) : "Environment 'test' must contain 'playroom2_size'.";
        assert (contains.stream().anyMatch(rel -> "playroom1_size".equals(rel.getTarget().getId()))) : "Environment 'test' must contain 'playroom1_size'.";
        assert (contains.stream().allMatch(rel -> !"production".equals(rel.getSource().getId()))) : "Environment 'production' cant be the source of these relationships.";
        contains.forEach(r -> {
            assert (r.getId() != null);
        });
    }

    @Test
    public void testRelationshipServiceLinkedWith() throws Exception {
        Set rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getTarget().getId())) : "Target of relationship 'yourMom' should be the 'test' environment";
        rels = ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.both)).named("IamYourFather").entities();
        assert (rels != null && rels.size() == 1) : "There should be 1 relationship conforming the filters";
        assert ("test".equals(((Relationship)rels.iterator().next()).getSource().getId())) : "Source of relationship 'IamYourFather' should be the 'test' environment";
    }

    @Test
    public void testRelationshipServiceLinkedWithAndDelete() throws Exception {
        Tenant tenant = (Tenant)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).entity();
        Relationship link = (Relationship)((Relationships.Single)((Relationships.ReadWrite)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feedlessResources()).get("host1")).relationships(Relationships.Direction.incoming)).linkWith("crossTenantLink", (Entity)tenant, null)).entity();
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships(Relationships.Direction.outgoing)).named("crossTenantLink").entities().size() == 1) : "Relation 'crossTenantLink' was not found.";
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships()).delete(link.getId());
        assert (((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships()).named("crossTenantLink").entities().size() == 0) : "Relation 'crossTenantLink' was found.";
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships()).delete(link.getId());
            assert (false) : "It shouldn't be possible to delete the same relationship twice";
        }
        catch (RelationNotFoundException relationNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceUpdateRelationship1() throws Exception {
        String someKey = "k3y";
        String someValue = "v4lu3";
        Relationship rel1 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (null == rel1.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        Relationship rel2 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel2.getId()) && null == rel2.getProperties().get("k3y")) : "There should not be any property with key 'k3y'";
        ((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).update(rel1.getId(), ((Relationship.Update.Builder)Relationship.Update.builder().withProperty("k3y", (Object)"v4lu3")).build());
        Relationship rel3 = (Relationship)((Relationships.ReadWrite)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).feedlessResources()).get("playroom2")).metrics()).get("playroom2_size")).relationships(Relationships.Direction.outgoing)).named("yourMom").entities().iterator().next();
        assert (rel1.getId().equals(rel3.getId()) && "v4lu3".equals(rel3.getProperties().get("k3y"))) : "There should be the property with key 'k3y' and value 'v4lu3'";
    }

    @Test
    public void testRelationshipServiceGetAllFilters() throws Exception {
        Set rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 4) : "There should be 4 relationships conforming the filters";
        assert (rels.stream().anyMatch(rel -> "playroom2_size".equals(rel.getTarget().getId())));
        assert (rels.stream().anyMatch(rel -> "playroom1".equals(rel.getTarget().getId())));
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships(Relationships.Direction.outgoing)).getAll(new RelationFilter[]{RelationWith.name((String)"contains"), RelationWith.targetOfType(Metric.class)})).entities();
        assert (rels != null && rels.size() == 2) : "There should be 2 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> Metric.class.equals(rel.getTarget().getClass()))) : "The type of all the targets should be the 'Metric'";
        rels = ((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships(Relationships.Direction.incoming)).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities();
        assert (rels != null && rels.size() == 1) : "There should be just 1 relationship conforming the filters";
        assert ("com.example.tenant".equals(((Relationship)rels.iterator().next()).getSource().getId())) : "Tenant 'com.example.tenant' was not found";
        rels = ((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).entities();
        assert (rels != null && rels.size() == 6) : "There should be 6 relationships conforming the filters";
        assert (rels.stream().allMatch(rel -> "test".equals(rel.getSource().getId()) || "production".equals(rel.getSource().getId()))) : "Source should be either 'test' or 'production'";
        assert (rels.stream().allMatch(rel -> Resource.class.equals(rel.getTarget().getClass()) || Metric.class.equals(rel.getTarget().getClass()))) : "Target should be either a metric or a resource";
    }

    @Test
    public void testRelationshipServiceGetAllFiltersWithSubsequentCalls() throws Exception {
        Metric metric = (Metric)((Metrics.Single)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class, Metric.class})})).metrics().get("playroom1_size")).entity();
        assert ("playroom1_size".equals(metric.getId())) : "Metric playroom1_size was not found using various relation filters";
        try {
            ((Metrics.Single)((Relationships.Multiple)((Relationships.Read)((Environments.Multiple)((Relationships.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).relationships()).named(Relationships.WellKnown.contains).environments().getAll(new Filter[0])).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"label", (Object[])new Object[]{"contains"}), RelationWith.targetsOfTypes((Class[])new Class[]{Resource.class})})).metrics().get("playroom1_size")).entity();
            assert (false) : "this code should not be reachable. There should be no metric reachable under 'RelationWith.targetsOfTypes(Resource.class))' filter";
        }
        catch (EntityNotFoundException entityNotFoundException) {
            // empty catch block
        }
    }

    @Test
    public void testRelationshipServiceCallChaining() throws Exception {
        MetricType metricType = (MetricType)((MetricTypes.Single)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).get("Playroom")).relationships()).named("owns").metricTypes().get("Size")).entity();
        assert ("Size".equals(metricType.getId())) : "ResourceType[Playroom] -owns-> MetricType[Size] was not found";
        try {
            ((MetricTypes.Single)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).get("Playroom")).relationships()).named("contains").metricTypes().get("Size")).entity();
            assert (false) : "There is no such an entity satisfying the query, this code shouldn't be reachable";
        }
        catch (EntityNotFoundException e) {
            // empty catch block
        }
        Set resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).get("Playroom")).relationships()).named("defines").resources().getAll(new Filter[0])).entities();
        assert (resources.stream().allMatch(res -> "playroom1".equals(res.getId()) || "playroom2".equals(res.getId()))) : "ResourceType[Playroom] -defines-> resources called playroom1 and playroom2";
        resources = ((Resources.Multiple)((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).resourceTypes()).get("Playroom")).relationships()).named("owns").resources().getAll(new Filter[0])).entities();
        assert (resources.isEmpty()) : "No resources should be found under the relationship called owns from resource type";
    }

    @Test
    public void testEnvironments() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query q = Query.empty().asBuilder().with((QueryFragment[])PathFragment.from((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)id)})).build();
            Page envs = this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            Assert.assertEquals((long)1L, (long)envs.size());
            Environment env = (Environment)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(id)).entity();
            Assert.assertEquals((Object)id, (Object)env.getId());
            env = (Environment)this.inventory.getBackend().convert(envs.get(0), Environment.class);
            Assert.assertEquals((Object)id, (Object)env.getId());
            return null;
        };
        test.apply("com.acme.tenant", "production");
        test.apply("com.example.tenant", "test");
        Query q = Query.empty().asBuilder().with(new QueryFragment[]{PathFragment.from((Filter)With.type(Environment.class))}).build();
        Assert.assertEquals((long)2L, (long)this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).size());
    }

    @Test
    public void testResourceTypes() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)id)}).get();
            Page results = this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()}));
            assert (!results.isEmpty());
            ResourceType rt = (ResourceType)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(id)).entity();
            assert (rt.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL");
        test.apply("com.example.tenant", "Kachna");
        test.apply("com.example.tenant", "Playroom");
        Query query = Query.path().with(new Filter[]{With.type(ResourceType.class)}).get();
        assert (3 == this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).size());
    }

    @Test
    public void testMetricDefinitions() throws Exception {
        BiFunction<String, String, Void> test = (tenantId, id) -> {
            Query query = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(MetricType.class), With.id((String)id)}).get();
            assert (!this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).isEmpty());
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).metricTypes()).get(id)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "ResponseTime");
        test.apply("com.example.tenant", "Size");
        Query query = Query.path().with(new Filter[]{With.type(MetricType.class)}).get();
        assert (2 == this.inventory.getBackend().query(query, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).size());
    }

    @Test
    public void testMetricTypesLinkedToResourceTypes() throws Exception {
        TriFunction<String, String, String, Void> test = (tenantId, resourceTypeId, id) -> {
            Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)resourceTypeId), Related.by((Relationships.WellKnown)Relationships.WellKnown.owns), With.type(MetricType.class), With.id((String)id)}).get();
            assert (!this.inventory.getBackend().query(q, Pager.unlimited((Order[])new Order[]{Order.unspecified()})).isEmpty());
            MetricType md = (MetricType)((MetricTypes.Single)((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).resourceTypes()).get(resourceTypeId)).metricTypes()).get(id)).entity();
            assert (md.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "URL", "ResponseTime");
        test.apply("com.example.tenant", "Playroom", "Size");
    }

    @Test
    public void testMetrics() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, metricDefId, id) -> {
            Metric m = (Metric)((Metrics.Multiple)((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessMetrics()).getAll((Filter[][])new Filter[][]{{Defined.by((MetricType)new MetricType(tenantId, metricDefId))}, {With.id((String)id)}})).entities().iterator().next();
            assert (m.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "ResponseTime", "host1_ping_response");
        test.apply("com.example.tenant", "test", "Size", "playroom1_size");
        test.apply("com.example.tenant", "test", "Size", "playroom2_size");
        Assert.assertEquals((long)4L, (long)this.inventory.getBackend().query(Query.path().with(new Filter[]{With.type(Metric.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).size());
    }

    @Test
    public void testResources() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceTypeId, id) -> {
            Resource r = (Resource)((Resources.Multiple)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).getAll((Filter[][])new Filter[][]{{Defined.by((ResourceType)new ResourceType(tenantId, resourceTypeId, "1.0"))}, {With.id((String)id)}})).entities().iterator().next();
            assert (r.getId().equals(id));
            return null;
        };
        test.apply("com.acme.tenant", "production", "URL", "host1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom1");
        test.apply("com.example.tenant", "test", "Playroom", "playroom2");
        Assert.assertEquals((long)6L, (long)this.inventory.getBackend().query(Query.path().with(new Filter[]{With.type(Resource.class)}).get(), Pager.unlimited((Order[])new Order[]{Order.unspecified()})).size());
    }

    @Test
    public void testAssociateMetricWithResource() throws Exception {
        TetraFunction<String, String, String, String, Void> test = (tenantId, environmentId, resourceId, metricId) -> {
            Metric m = (Metric)((Metrics.Single)((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get(tenantId)).environments()).get(environmentId)).feedlessResources()).get(resourceId)).metrics()).get(metricId)).entity();
            assert (metricId.equals(m.getId()));
            return null;
        };
        test.apply("com.acme.tenant", "production", "host1", "host1_ping_response");
        test.apply("com.example.tenant", "test", "playroom1", "playroom1_size");
        test.apply("com.example.tenant", "test", "playroom2", "playroom2_size");
    }

    @Test
    public void queryMultipleTenants() throws Exception {
        Set tenants = ((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).entities();
        assert (tenants.size() == 2);
    }

    @Test
    public void queryMultipleEnvironments() throws Exception {
        Set environments = ((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).entities();
        assert (environments.size() == 2);
    }

    @Test
    public void queryMultipleResourceTypes() throws Exception {
        Set types = ((ResourceTypes.Multiple)((ResourceTypes.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).resourceTypes()).getAll(new Filter[0])).entities();
        assert (types.size() == 3);
    }

    @Test
    public void queryMultipleMetricDefs() throws Exception {
        Set types = ((MetricTypes.Multiple)((MetricTypes.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).metricTypes()).getAll(new Filter[0])).entities();
        assert (types.size() == 2);
    }

    @Test
    public void queryMultipleResources() throws Exception {
        Set rs = ((Resources.Multiple)((Resources.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessResources()).getAll(new Filter[0])).entities();
        assert (rs.size() == 3);
    }

    @Test
    public void queryMultipleMetrics() throws Exception {
        Set ms = ((Metrics.Multiple)((Metrics.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0])).entities();
        assert (ms.size() == 3);
    }

    @Test
    public void testNoTwoFeedsWithSameID() throws Exception {
        Feeds.ReadWrite feeds = (Feeds.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feeds();
        Feed f1 = (Feed)feeds.create(new Feed.Blueprint("feed", null)).entity();
        Feed f2 = null;
        try {
            f2 = (Feed)feeds.create(new Feed.Blueprint("feed", null)).entity();
        }
        catch (FeedAlreadyRegisteredException fare) {
            // empty catch block
        }
        f2 = (Feed)feeds.create(new Feed.Blueprint(null, null)).entity();
        assert (f1.getId().equals("feed"));
        assert (!f1.getId().equals(f2.getId()));
    }

    @Test
    public void testNoTwoEquivalentEntitiesOnTheSamePath() throws Exception {
        try {
            this.inventory.tenants().create((Entity.Blueprint)new Tenant.Blueprint("com.acme.tenant"));
            Assert.fail((String)"Creating tenant with existing ID should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).create((Entity.Blueprint)new Environment.Blueprint("production"));
            Assert.fail((String)"Creating environment with existing ID should fail");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).feedlessResources()).create((Entity.Blueprint)new Resource.Blueprint("host1", "URL"));
            Assert.fail((String)"Creating resource with existing ID should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testContainsLoopsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (Entity)new Tenant("com.example.tenant"), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", (Entity)new Tenant("com.example.tenant"), null);
            Assert.fail((String)"Self-loops in contains should be disallowed");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (Entity)new Tenant("com.example.tenant"), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships(Relationships.Direction.incoming)).linkWith("contains", (Entity)new Environment("com.example.tenant", "test"), null);
            Assert.fail((String)"Loops in contains should be disallowed");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testContainsDiamondsImpossible() throws Exception {
        try {
            ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).relationships(Relationships.Direction.outgoing)).linkWith("contains", (Entity)new ResourceType("com.acme.tenant", "URL", "1.0"), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException e) {
            // empty catch block
        }
        try {
            ((Relationships.ReadWrite)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).resourceTypes()).get("URL")).relationships(Relationships.Direction.incoming)).linkWith("contains", (Entity)new Tenant("com.example.tenant"), null);
            Assert.fail((String)"Entity cannot be contained in 2 or more others");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testPropertiesCreated() throws Exception {
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).entity();
        Assert.assertEquals((long)1L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"moc", t.getProperties().get("kachny"));
    }

    @Test
    public void testPropertiesUpdatedOnEntities() throws Exception {
        this.inventory.tenants().update("com.acme.tenant", (Object)((Tenant.Update.Builder)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        Tenant t = (Tenant)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).entity();
        Assert.assertEquals((long)2L, (long)t.getProperties().size());
        Assert.assertEquals((Object)"many", t.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", t.getProperties().get("hammer"));
        this.inventory.tenants().update("com.acme.tenant", (Object)((Tenant.Update.Builder)Tenant.Update.builder().withProperty("kachny", (Object)"moc")).build());
        this.testPropertiesCreated();
    }

    @Test
    public void testPropertiesUpdatedOnRelationships() throws Exception {
        Relationship r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).relationships()).update(r.getId(), ((Relationship.Update.Builder)((Relationship.Update.Builder)Relationship.Update.builder().withProperty("ducks", (Object)"many")).withProperty("hammer", (Object)"nails")).build());
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)2L, (long)r.getProperties().size());
        Assert.assertEquals((Object)"many", r.getProperties().get("ducks"));
        Assert.assertEquals((Object)"nails", r.getProperties().get("hammer"));
        ((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).relationships()).update(r.getId(), new Relationship.Update(null));
        r = (Relationship)((Relationships.Multiple)((Relationships.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).relationships()).getAll(new RelationFilter[]{RelationWith.name((String)"contains")})).entities().iterator().next();
        Assert.assertEquals((long)0L, (long)r.getProperties().size());
    }

    @Test
    public void testPaging() throws Exception {
        ArrayList allResults = new ArrayList(((Metrics.Multiple)((Metrics.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0])).entities(Pager.unlimited((Order[])new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)})));
        assert (allResults.size() == 3);
        Pager firstPage = new Pager(0, 1, new Order[]{Order.by((String)"id", (Order.Direction)Order.Direction.DESCENDING)});
        Metrics.Multiple metrics = (Metrics.Multiple)((Metrics.Read)((Environments.Multiple)((Environments.Read)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[0])).environments()).getAll(new Filter[0])).feedlessMetrics()).getAll(new Filter[0]);
        Page ms = metrics.entities(firstPage);
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)ms.get(0)).equals(allResults.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)ms.get(0)).equals(allResults.get(1)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (((Metric)ms.get(0)).equals(allResults.get(2)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        assert (ms.getTotalSize() == 3L);
        assert (ms.size() == 0);
        firstPage = new Pager(0, 1, new Order[]{Order.unspecified()});
        ms = metrics.entities(firstPage);
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(ms.get(0)));
        ms = metrics.entities(firstPage.nextPage());
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(ms.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage());
        assert (ms.size() == 1);
        assert (ms.getTotalSize() == 3L);
        assert (allResults.remove(ms.get(0)));
        ms = metrics.entities(firstPage.nextPage().nextPage().nextPage());
        assert (ms.getTotalSize() == 3L);
        assert (ms.size() == 0);
    }

    @Test
    public void testGettingResourcesFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).allResources().getAll(new Filter[0])).entities();
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "host1".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource1".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource2".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedResource3".equals(r.getId())));
    }

    @Test
    public void testGettingMetricsFromFeedsUsingEnvironments() throws Exception {
        Set rs = ((Metrics.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.acme.tenant")).environments()).get("production")).allMetrics().getAll(new Filter[0])).entities();
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "host1_ping_response".equals(r.getId())));
        Assert.assertTrue((boolean)rs.stream().anyMatch(r -> "feedMetric1".equals(r.getId())));
    }

    @Test
    public void testAllPathsMentionedInExceptions() throws Exception {
        try {
            ((Metrics.Single)((Metrics.Read)((Resources.Multiple)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("non-tenant")).environments()).get("non-env")).allResources().getAll(new Filter[0])).metrics()).get("m")).entity();
            Assert.fail((String)"Fetching non-existant entity should have failed");
        }
        catch (EntityNotFoundException e) {
            Filter[][] paths = e.getFilters();
            Assert.assertEquals((long)2L, (long)paths.length);
            Assert.assertArrayEquals((Object[])Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)"non-tenant"), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)"non-env"), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class), Related.by((Relationships.WellKnown)Relationships.WellKnown.owns), With.type(Metric.class), With.id((String)"m")}).get(), (Object[])paths[0]);
            Assert.assertArrayEquals((Object[])Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)"non-tenant"), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)"non-env"), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Resource.class), Related.by((Relationships.WellKnown)Relationships.WellKnown.owns), With.type(Metric.class), With.id((String)"m")}).get(), (Object[])paths[1]);
        }
    }

    @Test
    public void testFilterByPropertyValues() throws Exception {
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"kachny")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.property((String)"kachna")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"moc")})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValue((String)"kachny", (Object)"malo")})).anyExists());
        Assert.assertTrue((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"moc", "malo"})})).anyExists());
        Assert.assertFalse((boolean)((Tenants.Multiple)this.inventory.tenants().getAll(new Filter[]{With.propertyValues((String)"kachny", (Object[])new Object[]{"hodne", "malo"})})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"adult")})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.property((String)"infant")})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)true)})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValue((String)"adult", (Object)false)})).anyExists());
        Assert.assertTrue((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"adult", (Object[])new Object[]{false, true})})).anyExists());
        Assert.assertFalse((boolean)((Relationships.Multiple)((Relationships.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("com.example.tenant")).environments()).get("test")).relationships()).getAll(new RelationFilter[]{RelationWith.propertyValues((String)"adult", (Object[])new Object[]{false, "true"})})).anyExists());
    }

    @Test
    public void testObserveTenants() throws Exception {
        this.runObserverTest(Tenant.class, 0, 0, () -> {
            this.inventory.tenants().create((Entity.Blueprint)new Tenant.Blueprint("xxx"));
            this.inventory.tenants().update("xxx", (Object)Tenant.Update.builder().build());
            this.inventory.tenants().delete("xxx");
        });
    }

    @Test
    public void testObserveEnvironments() throws Exception {
        this.runObserverTest(Environment.class, 1, 1, () -> {
            this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).create((Entity.Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("xxx")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).update("xxx", (Object)Environment.Update.builder().build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).delete("xxx");
            this.inventory.tenants().delete("t");
        });
    }

    @Test
    public void testObserveResourceTypes() throws Exception {
        this.runObserverTest(ResourceType.class, 3, 3, () -> {
            this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).resourceTypes()).create((Entity.Blueprint)new ResourceType.Blueprint("rt", "1.0"));
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).resourceTypes()).update("rt", (Object)new ResourceType.Update(null, "2.0.0"));
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).create((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder().withId("mt")).withUnit(MetricUnit.BYTE).build());
            ArrayList createdRelationships = new ArrayList();
            this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
            ((MetricTypes.ReadAssociate)((ResourceTypes.Single)((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).resourceTypes()).get("rt")).metricTypes()).associate("mt");
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).delete("mt");
            Assert.assertEquals((long)1L, (long)createdRelationships.size());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).resourceTypes()).delete("rt");
            this.inventory.tenants().delete("t");
        });
    }

    @Test
    public void testObserveMetricTypes() throws Exception {
        this.runObserverTest(MetricType.class, 1, 1, () -> {
            this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).create((Entity.Blueprint)new MetricType.Blueprint("mt", MetricUnit.BYTE));
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).update("mt", (Object)MetricType.Update.builder().withUnit(MetricUnit.MILLI_SECOND).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).delete("mt");
        });
    }

    @Test
    public void testObserveMetrics() throws Exception {
        this.runObserverTest(Metric.class, 4, 2, () -> {
            this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).create((Entity.Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("e")).build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).create((Entity.Blueprint)new MetricType.Blueprint("mt", MetricUnit.BYTE));
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessMetrics()).create((Entity.Blueprint)new Metric.Blueprint("mt", "m"));
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessMetrics()).update("m", (Object)Metric.Update.builder().build());
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessMetrics()).delete("m");
        });
    }

    @Test
    public void testObserveResources() throws Exception {
        this.runObserverTest(Resource.class, 8, 3, () -> {
            this.inventory.tenants().create((Entity.Blueprint)((Tenant.Blueprint.Builder)Tenant.Blueprint.builder().withId("t")).build());
            ((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).create((Entity.Blueprint)((Environment.Blueprint.Builder)Environment.Blueprint.builder().withId("e")).build());
            ((ResourceTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).resourceTypes()).create((Entity.Blueprint)((ResourceType.Blueprint.Builder)ResourceType.Blueprint.builder().withId("rt")).withVersion("1.0").build());
            ((MetricTypes.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).metricTypes()).create((Entity.Blueprint)((MetricType.Blueprint.Builder)MetricType.Blueprint.builder().withId("mt")).withUnit(MetricUnit.BYTE).build());
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessResources()).create((Entity.Blueprint)new Resource.Blueprint("r", "rt"));
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessResources()).update("r", (Object)Resource.Update.builder().build());
            ((Metrics.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessMetrics()).create((Entity.Blueprint)((Metric.Blueprint.Builder)Metric.Blueprint.builder().withId("m")).withMetricTypeId("mt").build());
            ArrayList createdRelationships = new ArrayList();
            this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
            ((Metrics.ReadAssociate)((Resources.Single)((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessResources()).get("r")).metrics()).associate("m");
            Assert.assertEquals((long)1L, (long)createdRelationships.size());
            ((Resources.ReadWrite)((Environments.Single)((Environments.ReadWrite)((Tenants.Single)this.inventory.tenants().get("t")).environments()).get("e")).feedlessResources()).delete("r");
        });
    }

    @Test
    public void testBackendFind() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        CanonicalPath tenantPath = CanonicalPath.builder().withTenantId("com.acme.tenant").build();
        Object entity = backend.find(tenantPath);
        Tenant tenant = (Tenant)backend.convert(entity, Tenant.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)tenant.getId());
        CanonicalPath envPath = tenantPath.extend().withEnvironmentId("production").build();
        entity = backend.find(envPath);
        Environment env = (Environment)backend.convert(entity, Environment.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)env.getTenantId());
        Assert.assertEquals((Object)"production", (Object)env.getId());
        entity = backend.find(envPath.extend().withResourceId("host1").build());
        Resource r = (Resource)backend.convert(entity, Resource.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getTenantId());
        Assert.assertEquals((Object)"production", (Object)r.getEnvironmentId());
        Assert.assertNull((Object)r.getFeedId());
        Assert.assertEquals((Object)"host1", (Object)r.getId());
        entity = backend.find(envPath.extend().withMetricId("host1_ping_response").build());
        Metric m = (Metric)backend.convert(entity, Metric.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getTenantId());
        Assert.assertEquals((Object)"production", (Object)m.getEnvironmentId());
        Assert.assertNull((Object)m.getFeedId());
        Assert.assertEquals((Object)"host1_ping_response", (Object)m.getId());
        CanonicalPath feedPath = envPath.extend().withFeedId("feed1").build();
        entity = backend.find(feedPath);
        Feed f = (Feed)backend.convert(entity, Feed.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)f.getTenantId());
        Assert.assertEquals((Object)"production", (Object)f.getEnvironmentId());
        Assert.assertEquals((Object)"feed1", (Object)f.getId());
        entity = backend.find(feedPath.extend().withResourceId("feedResource1").build());
        r = (Resource)backend.convert(entity, Resource.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)r.getTenantId());
        Assert.assertEquals((Object)"production", (Object)r.getEnvironmentId());
        Assert.assertEquals((Object)"feed1", (Object)r.getFeedId());
        Assert.assertEquals((Object)"feedResource1", (Object)r.getId());
        entity = backend.find(feedPath.extend().withMetricId("feedMetric1").build());
        m = (Metric)backend.convert(entity, Metric.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)m.getTenantId());
        Assert.assertEquals((Object)"production", (Object)m.getEnvironmentId());
        Assert.assertEquals((Object)"feed1", (Object)m.getFeedId());
        Assert.assertEquals((Object)"feedMetric1", (Object)m.getId());
        entity = backend.find(tenantPath.extend().withResourceTypeId("URL").build());
        ResourceType rt = (ResourceType)backend.convert(entity, ResourceType.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)rt.getTenantId());
        Assert.assertEquals((Object)"URL", (Object)rt.getId());
        entity = backend.find(tenantPath.extend().withMetricTypeId("ResponseTime").build());
        MetricType mt = (MetricType)backend.convert(entity, MetricType.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)mt.getTenantId());
        Assert.assertEquals((Object)"ResponseTime", (Object)mt.getId());
    }

    @Test
    public void testBackendGetRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find(CanonicalPath.builder().withTenantId("com.acme.tenant").build());
        Object environment = backend.find(CanonicalPath.builder().withTenantId("com.acme.tenant").withEnvironmentId("production").build());
        Object r = backend.getRelationship(tenant, environment, Relationships.WellKnown.contains.name());
        Relationship rel = (Relationship)backend.convert(r, Relationship.class);
        Assert.assertEquals((Object)"com.acme.tenant", (Object)rel.getSource().getId());
        Assert.assertEquals((Object)"production", (Object)rel.getTarget().getId());
        Assert.assertEquals((Object)"contains", (Object)rel.getName());
    }

    @Test
    public void testBackendGetRelationships() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object entity = backend.find(CanonicalPath.builder().withTenantId("com.acme.tenant").build());
        Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(entity));
        Set rels = backend.getRelationships(entity, Relationships.Direction.both, new String[0]);
        Assert.assertEquals((long)3L, (long)rels.size());
        Function<Set, Stream> checks = es -> es.stream().map(e -> (Relationship)backend.convert(e, Relationship.class));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "production".equals(r.getTarget().getId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "URL".equals(r.getTarget().getId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "ResponseTime".equals(r.getTarget().getId())));
        rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
        Assert.assertTrue((boolean)rels.isEmpty());
        rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[0]);
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "production".equals(r.getTarget().getId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "URL".equals(r.getTarget().getId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> Relationships.WellKnown.contains.name().equals(r.getName()) && "com.acme.tenant".equals(r.getSource().getId()) && "ResponseTime".equals(r.getTarget().getId())));
        entity = backend.find(CanonicalPath.builder().withTenantId("com.example.tenant").withEnvironmentId("test").build());
        Assert.assertEquals((Object)"test", (Object)backend.extractId(entity));
        rels = backend.getRelationships(entity, Relationships.Direction.incoming, new String[0]);
        Assert.assertEquals((long)2L, (long)rels.size());
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "contains".equals(r.getName()) && "com.example.tenant".equals(r.getSource().getId())));
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "yourMom".equals(r.getName()) && "playroom2_size".equals(r.getSource().getId())));
        rels = backend.getRelationships(entity, Relationships.Direction.outgoing, new String[]{"IamYourFather"});
        Assert.assertEquals((long)1L, (long)rels.size());
        Assert.assertTrue((boolean)checks.apply(rels).anyMatch(r -> "IamYourFather".equals(r.getName()) && "playroom2_size".equals(r.getTarget().getId())));
    }

    @Test
    public void testBackendGetTransitiveClosure() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        TriFunction<Object, String, Relationships.Direction, Stream> test = (start, name, direction) -> {
            Iterator transitiveClosure = backend.getTransitiveClosureOver(start, name, direction);
            return StreamSupport.stream(Spliterators.spliterator(transitiveClosure, Integer.MAX_VALUE, 0), false).map(e -> backend.convert(e, backend.extractType(e)));
        };
        Object env = backend.find(CanonicalPath.builder().withTenantId("com.acme.tenant").withEnvironmentId("production").build());
        Object feed = backend.find(CanonicalPath.builder().withTenantId("com.acme.tenant").withEnvironmentId("production").withFeedId("feed1").build());
        Assert.assertEquals((long)4L, (long)test.apply(feed, "contains", Relationships.Direction.outgoing).count());
        Assert.assertFalse((boolean)test.apply(feed, "contains", Relationships.Direction.outgoing).anyMatch(e -> e instanceof Feed && "feed1".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, "contains", Relationships.Direction.outgoing).anyMatch(e -> e instanceof Resource && "feedResource1".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, "contains", Relationships.Direction.outgoing).anyMatch(e -> e instanceof Resource && "feedResource2".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, "contains", Relationships.Direction.outgoing).anyMatch(e -> e instanceof Resource && "feedResource3".equals(e.getId())));
        Assert.assertTrue((boolean)test.apply(env, "contains", Relationships.Direction.outgoing).anyMatch(e -> e instanceof Metric && "feedMetric1".equals(e.getId())));
        Assert.assertEquals((long)1L, (long)test.apply(env, "contains", Relationships.Direction.incoming).count());
        Assert.assertTrue((boolean)test.apply(env, "contains", Relationships.Direction.incoming).anyMatch(e -> e instanceof Tenant && "com.acme.tenant".equals(e.getId())));
    }

    @Test
    public void testBackendHasRelationship() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find(CanonicalPath.builder().withTenantId("com.example.tenant").build());
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.outgoing, "contains"));
        Assert.assertFalse((boolean)backend.hasRelationship(tenant, Relationships.Direction.incoming, "contains"));
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, Relationships.Direction.both, "contains"));
        Object env = backend.find(CanonicalPath.builder().withTenantId("com.example.tenant").withEnvironmentId("test").build());
        Assert.assertTrue((boolean)backend.hasRelationship(tenant, env, "contains"));
        Assert.assertFalse((boolean)backend.hasRelationship(tenant, env, "kachny"));
    }

    @Test
    public void testBackendExtractId() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Object tenant = backend.find(CanonicalPath.builder().withTenantId("com.example.tenant").build());
        Assert.assertEquals((Object)"com.example.tenant", (Object)backend.extractId(tenant));
    }

    @Test
    public void testBackendExtractType() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        CanonicalPath tenantPath = CanonicalPath.builder().withTenantId("com.acme.tenant").build();
        Object entity = backend.find(tenantPath);
        Assert.assertEquals(Tenant.class, (Object)backend.extractType(entity));
        CanonicalPath envPath = tenantPath.extend().withEnvironmentId("production").build();
        entity = backend.find(envPath);
        Assert.assertEquals(Environment.class, (Object)backend.extractType(entity));
        entity = backend.find(envPath.extend().withResourceId("host1").build());
        Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
        entity = backend.find(envPath.extend().withMetricId("host1_ping_response").build());
        Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
        CanonicalPath feedPath = envPath.extend().withFeedId("feed1").build();
        entity = backend.find(feedPath);
        Assert.assertEquals(Feed.class, (Object)backend.extractType(entity));
        entity = backend.find(feedPath.extend().withResourceId("feedResource1").build());
        Assert.assertEquals(Resource.class, (Object)backend.extractType(entity));
        entity = backend.find(feedPath.extend().withMetricId("feedMetric1").build());
        Assert.assertEquals(Metric.class, (Object)backend.extractType(entity));
        entity = backend.find(tenantPath.extend().withResourceTypeId("URL").build());
        Assert.assertEquals(ResourceType.class, (Object)backend.extractType(entity));
        entity = backend.find(tenantPath.extend().withMetricTypeId("ResponseTime").build());
        Assert.assertEquals(MetricType.class, (Object)backend.extractType(entity));
    }

    @Test
    public void testBackendQuery() throws Exception {
        InventoryBackend backend = this.inventory.getBackend();
        Pager unlimited = Pager.unlimited((Order[])new Order[]{Order.unspecified()});
        Query q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant")}).get();
        Page results = backend.query(q, unlimited);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"com.acme.tenant", (Object)backend.extractId(results.get(0)));
        q = Query.path().with(new Filter[]{With.type(Tenant.class), With.id((String)"com.acme.tenant"), Related.by((String)"contains"), With.type(Environment.class), With.id((String)"production")}).get();
        results = backend.query(q, unlimited);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"production", (Object)backend.extractId(results.get(0)));
        q = Query.path().with(new Filter[]{With.type(Tenant.class)}).filter().with(new Filter[]{Related.by((String)"contains"), With.type(ResourceType.class), With.id((String)"URL")}).path().with(new Filter[]{Related.by((String)"contains"), With.type(Environment.class)}).get();
        results = backend.query(q, unlimited);
        Assert.assertEquals((long)1L, (long)results.size());
        Assert.assertEquals((Object)"production", (Object)backend.extractId(results.get(0)));
    }

    private <T extends AbstractElement<?, U>, U extends AbstractElement.Update> void runObserverTest(Class<T> entityClass, int nofCreatedRelationships, int nofDeletedRelationships, Runnable payload) {
        ArrayList createdEntities = new ArrayList();
        ArrayList updatedEntities = new ArrayList();
        ArrayList deletedEntities = new ArrayList();
        ArrayList createdRelationships = new ArrayList();
        ArrayList deletedRelationships = new ArrayList();
        Subscription s1 = this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(createdEntities::add);
        Subscription s2 = this.inventory.observable(Interest.in(entityClass).being(Action.updated())).subscribe(updatedEntities::add);
        Subscription s3 = this.inventory.observable(Interest.in(entityClass).being(Action.deleted())).subscribe(deletedEntities::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.created())).subscribe(createdRelationships::add);
        this.inventory.observable(Interest.in(Relationship.class).being(Action.deleted())).subscribe(deletedRelationships::add);
        this.inventory.observable(Interest.in(entityClass).being(Action.created())).subscribe(t -> {});
        payload.run();
        Assert.assertEquals((long)1L, (long)createdEntities.size());
        Assert.assertEquals((long)1L, (long)updatedEntities.size());
        Assert.assertEquals((long)1L, (long)deletedEntities.size());
        Assert.assertEquals((long)nofCreatedRelationships, (long)createdRelationships.size());
        Assert.assertEquals((long)nofDeletedRelationships, (long)deletedRelationships.size());
        s1.unsubscribe();
        s2.unsubscribe();
        s3.unsubscribe();
        Assert.assertTrue((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.created())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.updated())));
        Assert.assertFalse((boolean)this.inventory.hasObservers(Interest.in(entityClass).being(Action.deleted())));
    }

    private static interface TetraFunction<T, U, V, W, R> {
        public R apply(T var1, U var2, V var3, W var4);
    }

    private static interface TriFunction<T, U, V, R> {
        public R apply(T var1, U var2, V var3);
    }
}

