/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.filters;

import java.util.Arrays;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.RelativePath;

public final class With {
    private With() {
    }

    public static Ids id(String id) {
        return new Ids(id);
    }

    public static Ids ids(String ... ids) {
        return new Ids(ids);
    }

    @SafeVarargs
    public static Types types(Class<? extends Entity<?, ?>> ... types) {
        return new Types(types);
    }

    public static Types type(Class<? extends Entity<?, ?>> type) {
        return new Types(type);
    }

    public static CanonicalPaths path(CanonicalPath path) {
        return new CanonicalPaths(path);
    }

    public static CanonicalPaths paths(CanonicalPath ... paths) {
        return new CanonicalPaths(paths);
    }

    public static RelativePaths relativePath(String markerLabel, RelativePath path) {
        return new RelativePaths(markerLabel, path);
    }

    public static RelativePaths relativePaths(String markerLabel, RelativePath ... paths) {
        return new RelativePaths(markerLabel, paths);
    }

    public static PropertyValues property(String name) {
        return new PropertyValues(name, new Object[0]);
    }

    public static PropertyValues propertyValue(String name, Object value) {
        return new PropertyValues(name, value);
    }

    public static PropertyValues propertyValues(String name, Object ... values) {
        return new PropertyValues(name, values);
    }

    public static final class PropertyValues
    extends Filter {
        private final String name;
        private final Object[] values;

        public PropertyValues(String name, Object ... values) {
            this.name = name;
            this.values = values;
        }

        public String getName() {
            return this.name;
        }

        public Object[] getValues() {
            return this.values;
        }

        public String toString() {
            return "PropertyValues[name='" + this.name + '\'' + ", values=" + Arrays.toString(this.values) + ']';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PropertyValues)) {
                return false;
            }
            PropertyValues that = (PropertyValues)o;
            return this.name.equals(that.name) && Arrays.equals(this.values, that.values);
        }

        public int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + Arrays.hashCode(this.values);
            return result;
        }
    }

    public static final class RelativePaths
    extends Filter {
        private final String markerLabel;
        private final RelativePath[] paths;

        public RelativePaths(String markerLabel, RelativePath ... paths) {
            this.markerLabel = markerLabel;
            this.paths = paths;
        }

        public String getMarkerLabel() {
            return this.markerLabel;
        }

        public RelativePath[] getPaths() {
            return this.paths;
        }

        public String toString() {
            return "RelativePaths" + Arrays.asList(this.paths).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof RelativePaths)) {
                return false;
            }
            RelativePaths other = (RelativePaths)o;
            return Arrays.equals(this.paths, other.paths);
        }

        public int hashCode() {
            return Arrays.hashCode(this.paths);
        }
    }

    public static final class CanonicalPaths
    extends Filter {
        private final CanonicalPath[] paths;

        public CanonicalPaths(CanonicalPath ... paths) {
            this.paths = paths;
        }

        public CanonicalPath[] getPaths() {
            return this.paths;
        }

        public String toString() {
            return "CanonicalPaths" + Arrays.asList(this.paths).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof CanonicalPaths)) {
                return false;
            }
            CanonicalPaths other = (CanonicalPaths)o;
            return Arrays.equals(this.paths, other.paths);
        }

        public int hashCode() {
            return Arrays.hashCode(this.paths);
        }
    }

    public static final class Types
    extends Filter {
        private final Class<? extends Entity<?, ?>>[] types;

        @SafeVarargs
        public Types(Class<? extends Entity<?, ?>> ... types) {
            this.types = types;
        }

        public Class<? extends Entity<?, ?>>[] getTypes() {
            return this.types;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder("Types[");
            if (this.types.length > 0) {
                ret.append(this.types[0].getSimpleName());
                for (int i = 1; i < this.types.length; ++i) {
                    ret.append(", ").append(this.types[i].getSimpleName());
                }
            }
            ret.append("]");
            return ret.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Types)) {
                return false;
            }
            Types other = (Types)o;
            return Arrays.equals(this.types, other.types);
        }

        public int hashCode() {
            return Arrays.hashCode(this.types);
        }
    }

    public static final class Ids
    extends Filter {
        private final String[] ids;

        public Ids(String ... ids) {
            this.ids = ids;
        }

        public String[] getIds() {
            return this.ids;
        }

        public String toString() {
            return "Ids" + Arrays.asList(this.ids).toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Ids)) {
                return false;
            }
            Ids other = (Ids)o;
            return Arrays.equals(this.ids, other.ids);
        }

        public int hashCode() {
            return Arrays.hashCode(this.ids);
        }
    }
}

