/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.api.model;

import com.google.gson.annotations.Expose;
import java.util.Map;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlRootElement;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.ElementBlueprintVisitor;
import org.hawkular.inventory.api.model.ElementUpdateVisitor;
import org.hawkular.inventory.api.model.ElementVisitor;

@XmlRootElement
public final class Relationship
extends AbstractElement<Blueprint, Update> {
    @XmlAttribute
    @Expose
    private final String id;
    @XmlAttribute
    @Expose
    private final String name;
    @Expose
    private final CanonicalPath source;
    @Expose
    private final CanonicalPath target;

    private Relationship() {
        this(null, null, null, null, null);
    }

    @Override
    public <R, P> R accept(ElementVisitor<R, P> visitor, P parameter) {
        return visitor.visitRelationship(this, parameter);
    }

    public Relationship(String id, String name, CanonicalPath source, CanonicalPath target) {
        this(id, name, source, target, null);
    }

    public Relationship(String id, String name, CanonicalPath source, CanonicalPath target, Map<String, Object> properties) {
        super(CanonicalPath.of().relationship(id).get(), properties);
        this.id = id;
        this.name = name;
        this.source = source;
        this.target = target;
    }

    @Override
    public AbstractElement.Updater<Update, Relationship> update() {
        return new AbstractElement.Updater<Update, Relationship>(u -> new Relationship(this.getId(), this.getName(), this.getSource(), this.getTarget(), u.getProperties()));
    }

    @Override
    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public CanonicalPath getSource() {
        return this.source;
    }

    public CanonicalPath getTarget() {
        return this.target;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder(this.getClass().getSimpleName());
        bld.append("[id='").append(this.id).append('\'');
        bld.append(", name='").append(this.name).append('\'');
        bld.append(", source=").append(this.source);
        bld.append(" --").append(this.name).append("--> ");
        bld.append(" target=").append(this.target);
        bld.append(']');
        return bld.toString();
    }

    public static final class Blueprint
    extends AbstractElement.Blueprint {
        private final String name;
        private final CanonicalPath otherEnd;
        private final Relationships.Direction direction;

        private Blueprint() {
            super(null);
            this.name = null;
            this.otherEnd = null;
            this.direction = null;
        }

        public Blueprint(Relationships.Direction direction, String name, CanonicalPath otherEnd, Map<String, Object> properties) {
            super(properties);
            this.name = name;
            this.otherEnd = otherEnd;
            this.direction = direction;
        }

        public String getName() {
            return this.name;
        }

        public Relationships.Direction getDirection() {
            return this.direction;
        }

        public CanonicalPath getOtherEnd() {
            return this.otherEnd;
        }

        @Override
        public <R, P> R accept(ElementBlueprintVisitor<R, P> visitor, P parameter) {
            return visitor.visitRelationship(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Blueprint.Builder<Blueprint, Builder> {
            private String name;
            private CanonicalPath otherEnd;
            private Relationships.Direction direction = Relationships.Direction.outgoing;

            public Builder withName(String name) {
                this.name = name;
                return this;
            }

            public Builder withOtherEnd(CanonicalPath path) {
                this.otherEnd = path;
                return this;
            }

            public Builder withDirection(Relationships.Direction direction) {
                this.direction = direction;
                return this;
            }

            @Override
            public Blueprint build() {
                return new Blueprint(this.direction, this.name, this.otherEnd, this.properties);
            }
        }
    }

    public static final class Update
    extends AbstractElement.Update {
        public static Builder builder() {
            return new Builder();
        }

        private Update() {
            this(null);
        }

        public Update(Map<String, Object> properties) {
            super(properties);
        }

        @Override
        public <R, P> R accept(ElementUpdateVisitor<R, P> visitor, P parameter) {
            return visitor.visitRelationship(this, parameter);
        }

        public static final class Builder
        extends AbstractElement.Update.Builder<Update, Builder> {
            @Override
            public Update build() {
                return new Update(this.properties);
            }
        }
    }
}

