/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.function.Function;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.ResolvableToMany;
import org.hawkular.inventory.api.ResolvableToSingle;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.Traversal;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.Util;

abstract class Fetcher<BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update>
extends Traversal<BE, E>
implements ResolvableToSingle<E, U>,
ResolvableToMany<E> {
    public Fetcher(TraversalContext<BE, E> context) {
        super(context);
    }

    @Override
    public E entity() throws EntityNotFoundException, RelationNotFoundException {
        return (E)this.readOnly(() -> {
            Object entity;
            Object ret;
            Page results = this.context.backend.query(this.context.select().get(), Pager.single());
            if (results.isEmpty()) {
                this.throwNotFoundException();
            }
            if (!this.isApplicable((AbstractElement<?, ?>)(ret = this.context.backend.convert(entity = results.get(0), this.context.entityClass)))) {
                this.throwNotFoundException();
            }
            return ret;
        });
    }

    @Override
    public void delete() {
        Util.delete(this.context, this.context.select().get());
    }

    @Override
    public void update(U u) throws EntityNotFoundException, RelationNotFoundException {
        Util.update(this.context, this.context.select().get(), u);
    }

    @Override
    public Page<E> entities(Pager pager) {
        return this.readOnly(() -> {
            Function<Object, AbstractElement> conversion = e -> this.context.backend.convert(e, this.context.entityClass);
            Function<AbstractElement, Boolean> filter = this.context.configuration.getResultFilter() == null ? null : e -> this.context.configuration.getResultFilter().isApplicable((AbstractElement<?, ?>)e);
            return this.context.backend.query(this.context.select().get(), pager, conversion, filter);
        });
    }

    private void throwNotFoundException() {
        if (Entity.class.isAssignableFrom(this.context.entityClass)) {
            throw new EntityNotFoundException(this.context.entityClass, Query.filters(this.context.select().get()));
        }
        throw new RelationNotFoundException((String)null, Query.filters(this.context.sourcePath));
    }
}

