/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.Iterator;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.base.BaseInventory;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.ObservableContext;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.Util;
import org.hawkular.inventory.base.spi.InventoryBackend;
import org.hawkular.inventory.base.spi.SwitchElementType;
import rx.subjects.Subject;

public final class TraversalContext<BE, E extends AbstractElement<?, ?>> {
    protected final BaseInventory<BE> inventory;
    protected final Query sourcePath;
    protected final Query selectCandidates;
    protected final InventoryBackend<BE> backend;
    protected final Class<E> entityClass;
    protected final Configuration configuration;
    private final ObservableContext observableContext;
    private final int transactionRetries;

    TraversalContext(BaseInventory<BE> inventory, Query sourcePath, Query selectCandidates, InventoryBackend<BE> backend, Class<E> entityClass, Configuration configuration, ObservableContext observableContext) {
        this.inventory = inventory;
        this.sourcePath = sourcePath;
        this.selectCandidates = selectCandidates;
        this.backend = backend;
        this.entityClass = entityClass;
        this.configuration = configuration;
        this.observableContext = observableContext;
        String retries = configuration.getProperty(BaseInventory.TRANSACTION_RETRIES, "5");
        this.transactionRetries = Integer.parseInt(retries);
    }

    private TraversalContext(BaseInventory<BE> inventory, Query sourcePath, Query selectCandidates, InventoryBackend<BE> backend, Class<E> entityClass, Configuration configuration, ObservableContext observableContext, int transactionRetries) {
        this.inventory = inventory;
        this.sourcePath = sourcePath;
        this.selectCandidates = selectCandidates;
        this.backend = backend;
        this.entityClass = entityClass;
        this.configuration = configuration;
        this.observableContext = observableContext;
        this.transactionRetries = transactionRetries;
    }

    Builder<BE, E> proceed() {
        return new Builder<BE, E>(this.inventory, this.hop(), Query.filter(), this.backend, this.entityClass, this.configuration, this.observableContext, this.transactionRetries);
    }

    <T extends Entity<?, ?>> Builder<BE, T> proceedTo(Relationships.WellKnown over, Class<T> entityType) {
        return new Builder<BE, T>(this.inventory, this.hop(), Query.filter(), this.backend, entityType, this.configuration, this.observableContext, this.transactionRetries).hop(Related.by(over), With.type(entityType));
    }

    Builder<BE, Relationship> proceedToRelationships(Relationships.Direction direction) {
        return new Builder<BE, Relationship>(this.inventory, this.hop(), Query.filter(), this.backend, Relationship.class, this.configuration, this.observableContext, this.transactionRetries).hop(new SwitchElementType(direction, false));
    }

    <T extends Entity<?, ?>> Builder<BE, T> proceedFromRelationshipsTo(Relationships.Direction direction, Class<T> entityType) {
        return new Builder<BE, T>(this.inventory, this.hop(), Query.filter(), this.backend, entityType, this.configuration, this.observableContext, this.transactionRetries).hop(new SwitchElementType(direction, true)).where(With.type(entityType));
    }

    Query.SymmetricExtender select() {
        return this.sourcePath.extend().filter().withExact(this.selectCandidates);
    }

    Query.SymmetricExtender hop() {
        return this.sourcePath.extend().path().withExact(this.selectCandidates).path();
    }

    TraversalContext<BE, E> replacePath(Query path) {
        return new TraversalContext<BE, E>(this.inventory, path, Query.empty(), this.backend, this.entityClass, this.configuration, this.observableContext, this.transactionRetries);
    }

    TraversalContext<BE, E> proceedTo(Path path) {
        if (!this.entityClass.equals(path.getSegment().getElementType())) {
            throw new IllegalArgumentException("Path doesn't point to the type of element currently being accessed.");
        }
        return this.replacePath(Util.extendTo(this, path));
    }

    <V> void notify(V entity, Action<V, V> action) {
        this.notify(entity, entity, action);
    }

    <C, V> void notify(V entity, C actionContext, Action<C, V> action) {
        Iterator<Subject<C, C>> subjects = this.observableContext.matchingSubjects(action, entity);
        while (subjects.hasNext()) {
            Subject<C, C> s = subjects.next();
            s.onNext(actionContext);
        }
    }

    public int getTransactionRetriesCount() {
        return this.transactionRetries;
    }

    void notifyAll(EntityAndPendingNotifications<?> entityAndNotifications) {
        entityAndNotifications.getNotifications().forEach(this::notify);
    }

    <C, V> void notify(EntityAndPendingNotifications.Notification<C, V> notification) {
        this.notify(notification.getValue(), notification.getActionContext(), notification.getAction());
    }

    public static final class Builder<BE, E extends AbstractElement<?, ?>> {
        private final BaseInventory<BE> inventory;
        private final Query.SymmetricExtender pathExtender;
        private final Query.SymmetricExtender selectExtender;
        private final InventoryBackend<BE> backend;
        private final Class<E> entityClass;
        private final Configuration configuration;
        private final ObservableContext observableContext;
        private final int transactionRetries;

        public Builder(BaseInventory<BE> inventory, Query.SymmetricExtender pathExtender, Query.SymmetricExtender selectExtender, InventoryBackend<BE> backend, Class<E> entityClass, Configuration configuration, ObservableContext observableContext, int transactionRetries) {
            this.inventory = inventory;
            this.pathExtender = pathExtender;
            this.selectExtender = selectExtender;
            this.backend = backend;
            this.entityClass = entityClass;
            this.configuration = configuration;
            this.observableContext = observableContext;
            this.transactionRetries = transactionRetries;
        }

        public Builder<BE, E> whereAll(Filter[][] filters) {
            if (filters.length == 1) {
                return this.where(filters[0]);
            }
            for (Filter[] fs : filters) {
                this.hop(new Filter[0]).where(fs);
            }
            return this;
        }

        public Builder<BE, E> where(Filter[][] filters) {
            this.selectExtender.filter().with(filters);
            return this;
        }

        public Builder<BE, E> where(Filter ... filters) {
            this.selectExtender.filter().with(filters);
            return this;
        }

        public Builder<BE, E> hop(Filter[][] filters) {
            this.selectExtender.path().with(filters);
            return this;
        }

        public Builder<BE, E> hop(Filter ... filters) {
            this.selectExtender.path().with(filters);
            return this;
        }

        TraversalContext<BE, E> get() {
            return new TraversalContext(this.inventory, this.pathExtender.get(), this.selectExtender.get(), this.backend, this.entityClass, this.configuration, this.observableContext, this.transactionRetries);
        }

        <T extends AbstractElement<?, ?>> TraversalContext<BE, T> getting(Class<T> entityType) {
            return new TraversalContext(this.inventory, this.pathExtender.get(), this.selectExtender.get(), this.backend, entityType, this.configuration, this.observableContext, this.transactionRetries);
        }
    }
}

