/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.base;

import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Log;
import org.hawkular.inventory.api.RelationAlreadyExistsException;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Marker;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.CanonicalPath;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.Path;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.RelativePath;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.base.EntityAndPendingNotifications;
import org.hawkular.inventory.base.Query;
import org.hawkular.inventory.base.RelationshipRules;
import org.hawkular.inventory.base.TransactionFailureException;
import org.hawkular.inventory.base.TraversalContext;
import org.hawkular.inventory.base.spi.CommitFailureException;
import org.hawkular.inventory.base.spi.ElementNotFoundException;
import org.hawkular.inventory.base.spi.InventoryBackend;

final class Util {
    private Util() {
    }

    public static <R> R runInTransaction(TraversalContext<?, ?> context, boolean readOnly, PotentiallyCommittingPayload<R> payload) {
        int failures = 0;
        CommitFailureException lastException = null;
        int maxFailures = context.getTransactionRetriesCount();
        while (failures++ < maxFailures) {
            try {
                InventoryBackend.Transaction t = context.backend.startTransaction(!readOnly);
                try {
                    R ret = payload.run(t);
                    if (readOnly) {
                        context.backend.commit(t);
                    }
                    return ret;
                }
                catch (Throwable e) {
                    context.backend.rollback(t);
                    throw e;
                }
            }
            catch (CommitFailureException e) {
                Log.LOGGER.debugf(e, "Commit attempt %d/%d failed: %s", failures, maxFailures, e.getMessage());
                lastException = e;
            }
        }
        throw new TransactionFailureException(lastException, failures);
    }

    public static <BE> BE getSingle(InventoryBackend<BE> backend, Query query, Class<? extends Entity<?, ?>> entityType) {
        Page<BE> results = backend.query(query, Pager.single());
        if (results.isEmpty()) {
            throw new EntityNotFoundException(entityType, Query.filters(query));
        }
        return results.get(0);
    }

    public static <BE> EntityAndPendingNotifications<Relationship> createAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, String relationship, BE target) {
        return Util.runInTransaction(context, false, t -> {
            Object source = Util.getSingle(traversalContext.backend, sourceQuery, sourceType);
            if (traversalContext.backend.hasRelationship(source, target, relationship)) {
                throw new RelationAlreadyExistsException(relationship, Query.filters(sourceQuery));
            }
            RelationshipRules.checkCreate(traversalContext.backend, source, Relationships.Direction.outgoing, relationship, target);
            Object relationshipObject = traversalContext.backend.relate(source, target, relationship, null);
            traversalContext.backend.commit(t);
            Relationship ret = traversalContext.backend.convert(relationshipObject, Relationship.class);
            return new EntityAndPendingNotifications<Relationship>(ret, new EntityAndPendingNotifications.Notification<Relationship, Relationship>(ret, ret, Action.created()));
        });
    }

    public static <BE> EntityAndPendingNotifications<Relationship> deleteAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, String relationship, BE target) {
        InventoryBackend backend = context.backend;
        return Util.runInTransaction(context, false, t -> {
            Object relationshipObject;
            Object source = Util.getSingle(backend, sourceQuery, sourceType);
            try {
                relationshipObject = backend.getRelationship(source, target, relationship);
            }
            catch (ElementNotFoundException e) {
                throw new RelationNotFoundException((Class<? extends Entity>)sourceType, relationship, Query.filters(sourceQuery), null, null);
            }
            RelationshipRules.checkDelete(backend, source, Relationships.Direction.outgoing, relationship, target);
            Relationship ret = backend.convert(relationshipObject, Relationship.class);
            backend.delete(relationshipObject);
            backend.commit(t);
            return new EntityAndPendingNotifications<Relationship>(ret, new EntityAndPendingNotifications.Notification<Relationship, Relationship>(ret, ret, Action.deleted()));
        });
    }

    public static <BE> Relationship getAssociation(TraversalContext<BE, ?> context, Query sourceQuery, Class<? extends Entity<?, ?>> sourceType, Query targetQuery, Class<? extends Entity<?, ?>> targetType, String rel) {
        InventoryBackend backend = context.backend;
        return Util.runInTransaction(context, true, t -> {
            Object relationship;
            Object source = Util.getSingle(backend, sourceQuery, sourceType);
            Object target = Util.getSingle(backend, targetQuery, targetType);
            try {
                relationship = backend.getRelationship(source, target, rel);
            }
            catch (ElementNotFoundException e) {
                throw new RelationNotFoundException((Class<? extends Entity>)sourceType, rel, Query.filters(sourceQuery), null, null);
            }
            return backend.convert(relationship, Relationship.class);
        });
    }

    public static Query queryTo(TraversalContext<?, ?> context, Path path) {
        if (path instanceof CanonicalPath) {
            return Query.to((CanonicalPath)path);
        }
        Query.SymmetricExtender extender = context.sourcePath.extend().path();
        extender.with(With.relativePath(null, (RelativePath)path));
        return extender.get();
    }

    public static Query extendTo(TraversalContext<?, ?> context, Path path) {
        if (path instanceof CanonicalPath) {
            return context.select().with(With.path((CanonicalPath)path)).get();
        }
        Marker marker = Marker.next();
        return context.sourcePath.extend().path().with(marker).with(context.selectCandidates).with(With.relativePath(marker.getLabel(), (RelativePath)path)).get();
    }

    public static <BE, E extends AbstractElement<?, U>, U extends AbstractElement.Update> void update(TraversalContext<BE, E> context, Query entityQuery, U update) {
        Object updated = Util.runInTransaction(context, false, t -> {
            Page entities = traversalContext.backend.query(entityQuery, Pager.single());
            if (entities.isEmpty()) {
                if (update instanceof Relationship.Update) {
                    throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
                }
                throw new EntityNotFoundException(traversalContext.entityClass, Query.filters(entityQuery));
            }
            Object toUpdate = entities.get(0);
            traversalContext.backend.update(toUpdate, update);
            traversalContext.backend.commit(t);
            return toUpdate;
        });
        Object entity = context.backend.convert(updated, context.entityClass);
        context.notify(entity, new Action.Update(entity, update), Action.updated());
    }

    public static <BE, E extends AbstractElement<?, ?>> void delete(TraversalContext<BE, E> context, Query entityQuery) {
        Util.runInTransaction(context, false, transaction -> {
            Page entities = traversalContext.backend.query(entityQuery, Pager.single());
            if (entities.isEmpty()) {
                if (traversalContext.entityClass.equals(Relationship.class)) {
                    throw new RelationNotFoundException((String)null, Query.filters(entityQuery));
                }
                throw new EntityNotFoundException(traversalContext.entityClass, Query.filters(entityQuery));
            }
            Object toDelete = entities.get(0);
            HashSet verticesToDeleteThatDefineSomething = new HashSet();
            HashSet deleted = new HashSet();
            HashSet deletedRels = new HashSet();
            traversalContext.backend.getTransitiveClosureOver(toDelete, Relationships.WellKnown.contains.name(), Relationships.Direction.outgoing).forEachRemaining(e -> {
                if (traversalContext.backend.hasRelationship(e, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    verticesToDeleteThatDefineSomething.add(e);
                } else {
                    deleted.add(e);
                }
                deletedRels.addAll(traversalContext.backend.getRelationships(e, Relationships.Direction.both, new String[0]));
            });
            if (traversalContext.backend.hasRelationship(toDelete, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                verticesToDeleteThatDefineSomething.add(toDelete);
            } else {
                deleted.add(toDelete);
            }
            deletedRels.addAll(traversalContext.backend.getRelationships(toDelete, Relationships.Direction.both, new String[0]));
            Set deletedEntities = deleted.stream().map(o -> traversalContext.backend.convert(o, traversalContext.backend.extractType(o))).collect(Collectors.toSet());
            Set deletedRelationships = deletedRels.stream().map(o -> traversalContext.backend.convert(o, Relationship.class)).collect(Collectors.toSet());
            for (Object e2 : deleted) {
                traversalContext.backend.delete(e2);
            }
            for (Object e2 : verticesToDeleteThatDefineSomething) {
                if (traversalContext.backend.hasRelationship(e2, Relationships.Direction.outgoing, Relationships.WellKnown.defines.name())) {
                    String rootId = traversalContext.backend.extractId(toDelete);
                    String definingId = traversalContext.backend.extractId(e2);
                    String rootType = traversalContext.entityClass.getSimpleName();
                    String definingType = traversalContext.backend.extractType(e2).getSimpleName();
                    String rootEntity = "Entity[id=" + rootId + ", type=" + rootType + "]";
                    String definingEntity = "Entity[id=" + definingId + ", type=" + definingType + "]";
                    throw new IllegalArgumentException("Could not delete entity " + rootEntity + ". The entity " + definingEntity + ", which it (indirectly) contains, acts as a definition for some " + "entities that are not deleted along with it, which would leave them without a " + "definition. This is illegal.");
                }
                traversalContext.backend.delete(e2);
            }
            traversalContext.backend.commit(transaction);
            for (Relationship r : deletedRelationships) {
                context.notify(r, Action.deleted());
            }
            for (Object e2 : deletedEntities) {
                context.notify(e2, Action.deleted());
            }
            return null;
        });
    }

    public static CanonicalPath canonicalize(String path, CanonicalPath canonicalPrefix, CanonicalPath relativeOrigin, Class<?> intendedFinalType) {
        Path p = Path.fromPartiallyUntypedString(path, canonicalPrefix, relativeOrigin, intendedFinalType);
        if (p instanceof RelativePath) {
            return ((RelativePath)p).applyTo(relativeOrigin);
        }
        return p.toCanonicalPath();
    }

    @FunctionalInterface
    public static interface PotentiallyCommittingPayload<R> {
        public R run(InventoryBackend.Transaction var1) throws CommitFailureException;
    }
}

