/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus.api;

import com.google.gson.annotations.Expose;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.bus.api.EnvironmentEvent;
import org.hawkular.inventory.bus.api.FeedEvent;
import org.hawkular.inventory.bus.api.MetricEvent;
import org.hawkular.inventory.bus.api.MetricTypeEvent;
import org.hawkular.inventory.bus.api.RelationshipEvent;
import org.hawkular.inventory.bus.api.ResourceEvent;
import org.hawkular.inventory.bus.api.ResourceTypeEvent;
import org.hawkular.inventory.bus.api.TenantEvent;

public abstract class InventoryEvent<T>
extends BasicMessage {
    @Expose
    private Action.Enumerated action;

    public static InventoryEvent<?> from(Action<?, ?> action, Object object) {
        if (object == null) {
            throw new IllegalArgumentException("object == null");
        }
        if (action == null) {
            throw new IllegalArgumentException("action == null");
        }
        if (object instanceof Tenant) {
            return new TenantEvent(action.asEnum(), (Tenant)object);
        }
        if (object instanceof Environment) {
            return new EnvironmentEvent(action.asEnum(), (Environment)object);
        }
        if (object instanceof Feed) {
            return new FeedEvent(action.asEnum(), (Feed)object);
        }
        if (object instanceof Metric) {
            return new MetricEvent(action.asEnum(), (Metric)object);
        }
        if (object instanceof MetricType) {
            return new MetricTypeEvent(action.asEnum(), (MetricType)object);
        }
        if (object instanceof Resource) {
            return new ResourceEvent(action.asEnum(), (Resource)object);
        }
        if (object instanceof ResourceType) {
            return new ResourceTypeEvent(action.asEnum(), (ResourceType)object);
        }
        if (object instanceof Relationship) {
            return new RelationshipEvent(action.asEnum(), (Relationship)object);
        }
        if (object instanceof Action.Update) {
            AbstractElement updated = (AbstractElement)((Action.Update)object).getOriginalEntity();
            updated.update().with((AbstractElement.Update)((Action.Update)object).getUpdate());
            return InventoryEvent.from(action, updated);
        }
        throw new IllegalArgumentException("Unsupported entity type: " + object.getClass());
    }

    protected InventoryEvent() {
    }

    protected InventoryEvent(Action.Enumerated action) {
        this.action = action;
    }

    public Action.Enumerated getAction() {
        return this.action;
    }

    public void setAction(Action.Enumerated action) {
        this.action = action;
    }

    public abstract T getObject();

    public abstract void setObject(T var1);
}

