/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.bus;

import java.util.HashMap;
import java.util.Map;
import javax.jms.JMSException;
import org.hawkular.bus.common.BasicMessage;
import org.hawkular.bus.common.MessageProcessor;
import org.hawkular.bus.common.producer.ProducerConnectionContext;
import org.hawkular.inventory.api.Action;
import org.hawkular.inventory.api.Interest;
import org.hawkular.inventory.bus.Log;
import org.hawkular.inventory.bus.api.InventoryEvent;

final class MessageSender {
    private final ProducerConnectionContext producerConnectionContext;
    private final MessageProcessor messageProcessor;

    public MessageSender(ProducerConnectionContext producerConnectionContext) {
        this.producerConnectionContext = producerConnectionContext;
        this.messageProcessor = new MessageProcessor();
    }

    public void send(Interest<?, ?> interest, Object inventoryEvent) {
        InventoryEvent message = InventoryEvent.from((Action)interest.getAction(), (Object)inventoryEvent);
        try {
            Map<String, String> headers = this.toHeaders(interest);
            this.messageProcessor.send(this.producerConnectionContext, (BasicMessage)message, headers);
            Log.LOG.debugf("Sent message %s with headers %s to %s", message, headers, this.producerConnectionContext.getDestination());
        }
        catch (JMSException e) {
            Log.LOG.failedToSendMessage(message.toString());
        }
    }

    private Map<String, String> toHeaders(Interest<?, ?> interest) {
        HashMap<String, String> ret = new HashMap<String, String>();
        ret.put("action", interest.getAction().asEnum().name().toLowerCase());
        ret.put("entityType", this.firstLetterLowercased(interest.getEntityType().getSimpleName()));
        return ret;
    }

    private String firstLetterLowercased(String source) {
        return Character.toLowerCase(source.charAt(0)) + source.substring(1);
    }
}

