/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop.spi;

import com.tinkerpop.blueprints.Element;
import java.util.HashMap;
import java.util.Map;

public final class IndexSpec {
    private final Map<String, Class<?>> properties;
    private final Class<? extends Element> elementType;

    public static Builder builder() {
        return new Builder();
    }

    public IndexSpec(Class<? extends Element> elementType, Map<String, Class<?>> properties) {
        this.elementType = elementType;
        this.properties = properties;
    }

    public Class<? extends Element> getElementType() {
        return this.elementType;
    }

    public Map<String, Class<?>> getProperties() {
        return this.properties;
    }

    public String toString() {
        return "IndexSpec[type=" + this.elementType.getSimpleName() + ",properties=" + this.properties + "]";
    }

    public static final class Builder {
        private final Map<String, Class<?>> properties = new HashMap();
        private Class<? extends Element> elementType;

        private Builder() {
        }

        public Builder withProperty(String propertyName, Class<?> propertyValueType) {
            this.properties.put(propertyName, propertyValueType);
            return this;
        }

        public Builder withElementType(Class<? extends Element> elementType) {
            this.elementType = elementType;
            return this;
        }

        public IndexSpec build() {
            return new IndexSpec(this.elementType, this.properties);
        }
    }
}

