/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Edge;
import com.tinkerpop.blueprints.Element;
import com.tinkerpop.blueprints.Graph;
import com.tinkerpop.blueprints.Predicate;
import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.Tokens;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import com.tinkerpop.pipes.Pipe;
import com.tinkerpop.pipes.PipeFunction;
import com.tinkerpop.pipes.branch.LoopPipe;
import com.tinkerpop.pipes.transform.TransformPipe;
import com.tinkerpop.pipes.util.structures.Pair;
import com.tinkerpop.pipes.util.structures.Row;
import com.tinkerpop.pipes.util.structures.Table;
import com.tinkerpop.pipes.util.structures.Tree;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.paging.Order;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.DrainedRangeFilterPipe;

final class HawkularPipeline<S, E>
extends GremlinPipeline<S, E>
implements Cloneable {
    private int asLabelCount;
    private final Deque<String> labelStack = new ArrayDeque<String>(2);
    private final Map<String, Long> counters = new HashMap<String, Long>();

    public HawkularPipeline() {
    }

    public HawkularPipeline(Object starts) {
        super(starts);
    }

    public HawkularPipeline(Object starts, boolean doQueryOptimization) {
        super(starts, doQueryOptimization);
    }

    public HawkularPipeline<S, E> remember() {
        String label = ")(*)#(*&$(" + this.asLabelCount++;
        this.labelStack.push(label);
        return this.as(label);
    }

    public HawkularPipeline<S, ?> recall() {
        return this.back(this.labelStack.pop());
    }

    public HawkularPipeline<S, Vertex> hasType(Constants.Type type) {
        return this.has(Constants.Property.__type.name(), type.name());
    }

    public HawkularPipeline<S, ? extends Element> hasEid(String eid) {
        return this.cast(this.has(Constants.Property.__eid.name(), eid));
    }

    public HawkularPipeline<S, Vertex> out(Relationships.WellKnown ... rel) {
        String[] srels = new String[rel.length];
        Arrays.setAll(srels, i -> rel[i].name());
        return this.out(srels);
    }

    public HawkularPipeline<S, Vertex> in(Relationships.WellKnown ... rel) {
        String[] srels = new String[rel.length];
        Arrays.setAll(srels, i -> rel[i].name());
        return this.in(srels);
    }

    public HawkularPipeline<S, Vertex> page(Pager pager) {
        return this.cast(Vertex.class).page(pager, (e, p) -> {
            String prop = Constants.Property.mapUserDefined(p);
            return (Comparable)e.getProperty(prop);
        });
    }

    public <V extends Comparable<V>> HawkularPipeline<S, E> page(Pager pager, BiFunction<E, String, V> propertyValueExtractor) {
        List order = pager.getOrder();
        if (!order.isEmpty()) {
            boolean specific = false;
            for (Order o : order) {
                if (!o.isSpecific()) continue;
                specific = true;
                break;
            }
            if (specific) {
                this.order(p -> {
                    int ret = 0;
                    for (Order ord : order) {
                        if (!ord.isSpecific()) continue;
                        Comparable a = (Comparable)propertyValueExtractor.apply(p.getA(), ord.getField());
                        Comparable b = (Comparable)propertyValueExtractor.apply(p.getB(), ord.getField());
                        ret = ord.isAscending() ? HawkularPipeline.safeCompare(a, b) : HawkularPipeline.safeCompare(b, a);
                        if (ret == 0) continue;
                        break;
                    }
                    return ret;
                });
            }
        }
        if (pager.isLimited()) {
            this.drainedRange(pager.getStart(), pager.getEnd() - 1);
        }
        return this;
    }

    private static <T extends Comparable<T>> int safeCompare(T a, T b) {
        if (a == null) {
            return b == null ? 0 : -1;
        }
        if (b == null) {
            return 1;
        }
        return a.compareTo(b);
    }

    public HawkularPipeline<S, E> counter(String name) {
        this.sideEffect(e -> this.counters.put(name, this.counters.getOrDefault(name, 0L) + 1L));
        return this;
    }

    public long getCount(String counterName) {
        return this.counters.getOrDefault(counterName, -1L);
    }

    public HawkularPipeline<S, E> _() {
        return this.cast(super._());
    }

    public <T> HawkularPipeline<S, T> add(Pipe<?, T> pipe) {
        return this.cast(super.add(pipe));
    }

    public HawkularPipeline<S, E> aggregate() {
        return this.cast(super.aggregate());
    }

    public HawkularPipeline<S, E> aggregate(Collection aggregate, PipeFunction<E, ?> aggregateFunction) {
        return this.cast(super.aggregate(aggregate, aggregateFunction));
    }

    public HawkularPipeline<S, E> aggregate(Collection<E> aggregate) {
        return this.cast(super.aggregate(aggregate));
    }

    public HawkularPipeline<S, E> aggregate(PipeFunction<E, ?> aggregateFunction) {
        return this.cast(super.aggregate(aggregateFunction));
    }

    public HawkularPipeline<S, E> and(Pipe<E, ?> ... pipes) {
        return this.cast(super.and(pipes));
    }

    public HawkularPipeline<S, E> as(String name) {
        return this.cast(super.as(name));
    }

    public HawkularPipeline<S, ?> back(String namedStep) {
        return this.cast(super.back(namedStep));
    }

    @Deprecated
    public HawkularPipeline<S, ?> back(int numberedStep) {
        return this.cast(super.back(numberedStep));
    }

    public HawkularPipeline<S, Vertex> both(int branchFactor, String ... labels) {
        return this.cast(super.both(branchFactor, labels));
    }

    public HawkularPipeline<S, Vertex> both(String ... labels) {
        return this.cast(super.both(labels));
    }

    public HawkularPipeline<S, Edge> bothE(int branchFactor, String ... labels) {
        return this.cast(super.bothE(branchFactor, labels));
    }

    public HawkularPipeline<S, Edge> bothE(String ... labels) {
        return this.cast(super.bothE(labels));
    }

    public HawkularPipeline<S, Vertex> bothV() {
        return this.cast(super.bothV());
    }

    public HawkularPipeline<S, ?> cap() {
        return this.cast(super.cap());
    }

    public <E1> HawkularPipeline<S, E1> cast(Class<E1> end) {
        return this.cast(super.cast(end));
    }

    public HawkularPipeline<S, ?> copySplit(Pipe<E, ?> ... pipes) {
        return this.cast(super.copySplit(pipes));
    }

    public HawkularPipeline<S, E> dedup() {
        return this.cast(super.dedup());
    }

    public HawkularPipeline<S, E> dedup(PipeFunction<E, ?> dedupFunction) {
        return this.cast(super.dedup(dedupFunction));
    }

    public HawkularPipeline<S, Edge> E() {
        return this.cast(super.E());
    }

    public HawkularPipeline<S, Edge> E(String key, Object value) {
        return this.cast(super.E(key, value));
    }

    public HawkularPipeline<S, E> enablePath() {
        return this.cast(super.enablePath());
    }

    public HawkularPipeline<S, E> except(Collection<E> collection) {
        return this.cast(super.except(collection));
    }

    public HawkularPipeline<S, E> except(String ... namedSteps) {
        return this.cast(super.except(namedSteps));
    }

    public HawkularPipeline<S, ?> exhaustMerge() {
        return this.cast(super.exhaustMerge());
    }

    public HawkularPipeline<S, ?> fairMerge() {
        return this.cast(super.fairMerge());
    }

    public HawkularPipeline<S, E> filter(PipeFunction<E, Boolean> filterFunction) {
        return this.cast(super.filter(filterFunction));
    }

    public HawkularPipeline<S, List> gather() {
        return this.cast(super.gather());
    }

    public HawkularPipeline<S, ?> gather(PipeFunction<List, ?> function) {
        return this.cast(super.gather(function));
    }

    public HawkularPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.cast(super.groupBy(keyFunction, valueFunction));
    }

    public HawkularPipeline<S, E> groupBy(PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.cast(super.groupBy(keyFunction, valueFunction, reduceFunction));
    }

    public HawkularPipeline<S, E> groupBy(Map<?, List<?>> map, PipeFunction keyFunction, PipeFunction valueFunction) {
        return this.cast(super.groupBy(map, keyFunction, valueFunction));
    }

    public HawkularPipeline<S, E> groupBy(Map reduceMap, PipeFunction keyFunction, PipeFunction valueFunction, PipeFunction reduceFunction) {
        return this.cast(super.groupBy(reduceMap, keyFunction, valueFunction, reduceFunction));
    }

    public HawkularPipeline<S, E> groupCount() {
        return this.cast(super.groupCount());
    }

    public HawkularPipeline<S, E> groupCount(PipeFunction keyFunction) {
        return this.cast(super.groupCount(keyFunction));
    }

    public HawkularPipeline<S, E> groupCount(PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.cast(super.groupCount(keyFunction, valueFunction));
    }

    public HawkularPipeline<S, E> groupCount(Map<?, Number> map) {
        return this.cast(super.groupCount(map));
    }

    public HawkularPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction) {
        return this.cast(super.groupCount(map, keyFunction));
    }

    public HawkularPipeline<S, E> groupCount(Map<?, Number> map, PipeFunction keyFunction, PipeFunction<Pair<?, Number>, Number> valueFunction) {
        return this.cast(super.groupCount(map, keyFunction, valueFunction));
    }

    public HawkularPipeline<S, ? extends Element> has(String key) {
        return this.cast(super.has(key));
    }

    public HawkularPipeline<S, ? extends Element> has(String key, Tokens.T compareToken, Object value) {
        return this.cast(super.has(key, compareToken, value));
    }

    public HawkularPipeline<S, ? extends Element> has(String key, Predicate predicate, Object value) {
        return this.cast(super.has(key, predicate, value));
    }

    public HawkularPipeline<S, ? extends Element> has(String key, Object value) {
        return this.cast(super.has(key, value));
    }

    public HawkularPipeline<S, ? extends Element> hasNot(String key) {
        return this.cast(super.hasNot(key));
    }

    public HawkularPipeline<S, ? extends Element> hasNot(String key, Object value) {
        return this.cast(super.hasNot(key, value));
    }

    public HawkularPipeline<S, Object> id() {
        return this.cast(super.id());
    }

    public HawkularPipeline<S, Edge> idEdge(Graph graph) {
        return this.cast(super.idEdge(graph));
    }

    public HawkularPipeline<S, Vertex> idVertex(Graph graph) {
        return this.cast(super.idVertex(graph));
    }

    public HawkularPipeline<S, ?> ifThenElse(PipeFunction<E, Boolean> ifFunction, PipeFunction<E, ?> thenFunction, PipeFunction<E, ?> elseFunction) {
        return this.cast(super.ifThenElse(ifFunction, thenFunction, elseFunction));
    }

    public HawkularPipeline<S, Vertex> in(int branchFactor, String ... labels) {
        return this.cast(super.in(branchFactor, labels));
    }

    public HawkularPipeline<S, Vertex> in(String ... labels) {
        return this.cast(super.in(labels));
    }

    public HawkularPipeline<S, Edge> inE(int branchFactor, String ... labels) {
        return this.cast(super.inE(branchFactor, labels));
    }

    public HawkularPipeline<S, Edge> inE(String ... labels) {
        return this.cast(super.inE(labels));
    }

    public HawkularPipeline<S, ? extends Element> interval(String key, Comparable startValue, Comparable endValue) {
        return this.cast(super.interval(key, startValue, endValue));
    }

    public HawkularPipeline<S, Vertex> inV() {
        return this.cast(super.inV());
    }

    public void iterate() {
        super.iterate();
    }

    public HawkularPipeline<S, String> label() {
        return this.cast(super.label());
    }

    public HawkularPipeline<S, Vertex> linkBoth(String label, String namedStep) {
        return this.cast(super.linkBoth(label, namedStep));
    }

    public HawkularPipeline<S, Vertex> linkBoth(String label, Vertex other) {
        return this.cast(super.linkBoth(label, other));
    }

    public HawkularPipeline<S, Vertex> linkIn(String label, String namedStep) {
        return this.cast(super.linkIn(label, namedStep));
    }

    public HawkularPipeline<S, Vertex> linkIn(String label, Vertex other) {
        return this.cast(super.linkIn(label, other));
    }

    public HawkularPipeline<S, Vertex> linkOut(String label, String namedStep) {
        return this.cast(super.linkOut(label, namedStep));
    }

    public HawkularPipeline<S, Vertex> linkOut(String label, Vertex other) {
        return this.cast(super.linkOut(label, other));
    }

    public HawkularPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.cast(super.loop(namedStep, whileFunction));
    }

    public HawkularPipeline<S, E> loop(String namedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.cast(super.loop(namedStep, whileFunction, emitFunction));
    }

    @Deprecated
    public HawkularPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction) {
        return this.cast(super.loop(numberedStep, whileFunction));
    }

    @Deprecated
    public HawkularPipeline<S, E> loop(int numberedStep, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> whileFunction, PipeFunction<LoopPipe.LoopBundle<E>, Boolean> emitFunction) {
        return this.cast(super.loop(numberedStep, whileFunction, emitFunction));
    }

    public HawkularPipeline<S, Map<String, Object>> map(String ... keys) {
        return this.cast(super.map(keys));
    }

    public HawkularPipeline<S, E> memoize(String namedStep) {
        return this.cast(super.memoize(namedStep));
    }

    public HawkularPipeline<S, E> memoize(String namedStep, Map map) {
        return this.cast(super.memoize(namedStep, map));
    }

    @Deprecated
    public HawkularPipeline<S, E> memoize(int numberedStep) {
        return this.cast(super.memoize(numberedStep));
    }

    @Deprecated
    public HawkularPipeline<S, E> memoize(int numberedStep, Map map) {
        return this.cast(super.memoize(numberedStep, map));
    }

    public HawkularPipeline<S, E> optimize(boolean optimize) {
        return this.cast(super.optimize(optimize));
    }

    public HawkularPipeline<S, ?> optional(String namedStep) {
        return this.cast(super.optional(namedStep));
    }

    @Deprecated
    public HawkularPipeline<S, ?> optional(int numberedStep) {
        return this.cast(super.optional(numberedStep));
    }

    public HawkularPipeline<S, E> or(Pipe<E, ?> ... pipes) {
        return this.cast(super.or(pipes));
    }

    public HawkularPipeline<S, E> order() {
        return this.cast(super.order());
    }

    public HawkularPipeline<S, E> order(PipeFunction<Pair<E, E>, Integer> compareFunction) {
        return this.cast(super.order(compareFunction));
    }

    public HawkularPipeline<S, E> order(TransformPipe.Order order) {
        return this.cast(super.order(order));
    }

    public HawkularPipeline<S, E> order(Tokens.T order) {
        return this.cast(super.order(order));
    }

    public HawkularPipeline<S, ?> orderMap(PipeFunction<Pair<Map.Entry, Map.Entry>, Integer> compareFunction) {
        return this.cast(super.orderMap(compareFunction));
    }

    public HawkularPipeline<S, ?> orderMap(TransformPipe.Order order) {
        return this.cast(super.orderMap(order));
    }

    public HawkularPipeline<S, ?> orderMap(Tokens.T order) {
        return this.cast(super.orderMap(order));
    }

    public HawkularPipeline<S, Vertex> out(int branchFactor, String ... labels) {
        return this.cast(super.out(branchFactor, labels));
    }

    public HawkularPipeline<S, Vertex> out(String ... labels) {
        return this.cast(super.out(labels));
    }

    public HawkularPipeline<S, Edge> outE(int branchFactor, String ... labels) {
        return this.cast(super.outE(branchFactor, labels));
    }

    public HawkularPipeline<S, Edge> outE(String ... labels) {
        return this.cast(super.outE(labels));
    }

    public HawkularPipeline<S, Vertex> outV() {
        return this.cast(super.outV());
    }

    public HawkularPipeline<S, List> path(PipeFunction ... pathFunctions) {
        return this.cast(super.path(pathFunctions));
    }

    public HawkularPipeline<S, Object> property(String key) {
        return this.cast(super.property(key));
    }

    public HawkularPipeline<S, E> random(Double bias) {
        return this.cast(super.random(bias));
    }

    public HawkularPipeline<S, E> range(int low, int high) {
        return this.cast(super.range(low, high));
    }

    public HawkularPipeline<S, E> drainedRange(int low, int high) {
        this.add((Pipe)new DrainedRangeFilterPipe(low, high));
        return this;
    }

    public void remove() {
        super.remove();
    }

    public HawkularPipeline<S, E> retain(Collection<E> collection) {
        return this.cast(super.retain(collection));
    }

    public HawkularPipeline<S, E> retain(String ... namedSteps) {
        return this.cast(super.retain(namedSteps));
    }

    public HawkularPipeline<S, ?> scatter() {
        return this.cast(super.scatter());
    }

    public HawkularPipeline<S, Row> select() {
        return this.cast(super.select());
    }

    public HawkularPipeline<S, Row> select(PipeFunction ... columnFunctions) {
        return this.cast(super.select(columnFunctions));
    }

    public HawkularPipeline<S, Row> select(Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.cast(super.select(stepNames, columnFunctions));
    }

    public HawkularPipeline<S, List> shuffle() {
        return this.cast(super.shuffle());
    }

    public HawkularPipeline<S, E> sideEffect(PipeFunction<E, ?> sideEffectFunction) {
        return this.cast(super.sideEffect(sideEffectFunction));
    }

    public HawkularPipeline<S, E> simplePath() {
        return this.cast(super.simplePath());
    }

    public HawkularPipeline<S, S> start(S object) {
        return this.cast(super.start(object));
    }

    public HawkularPipeline<S, ?> step(PipeFunction function) {
        return this.cast(super.step(function));
    }

    public <T> HawkularPipeline<S, T> step(Pipe<E, T> pipe) {
        return this.cast(super.step(pipe));
    }

    public HawkularPipeline<S, E> store() {
        return this.cast(super.store());
    }

    public HawkularPipeline<S, E> store(Collection storage, PipeFunction<E, ?> storageFunction) {
        return this.cast(super.store(storage, storageFunction));
    }

    public HawkularPipeline<S, E> store(Collection<E> storage) {
        return this.cast(super.store(storage));
    }

    public HawkularPipeline<S, E> store(PipeFunction<E, ?> storageFunction) {
        return this.cast(super.store(storageFunction));
    }

    public HawkularPipeline<S, E> table() {
        return this.cast(super.table());
    }

    public HawkularPipeline<S, E> table(PipeFunction ... columnFunctions) {
        return this.cast(super.table(columnFunctions));
    }

    public HawkularPipeline<S, E> table(Table table) {
        return this.cast(super.table(table));
    }

    public HawkularPipeline<S, E> table(Table table, PipeFunction ... columnFunctions) {
        return this.cast(super.table(table, columnFunctions));
    }

    public HawkularPipeline<S, E> table(Table table, Collection<String> stepNames, PipeFunction ... columnFunctions) {
        return this.cast(super.table(table, stepNames, columnFunctions));
    }

    public <T> HawkularPipeline<S, T> transform(PipeFunction<E, T> function) {
        return this.cast(super.transform(function));
    }

    public HawkularPipeline<S, E> tree(PipeFunction ... branchFunctions) {
        return this.cast(super.tree(branchFunctions));
    }

    public HawkularPipeline<S, E> tree(Tree tree, PipeFunction ... branchFunctions) {
        return this.cast(super.tree(tree, branchFunctions));
    }

    public HawkularPipeline<S, Vertex> V() {
        return this.cast(super.V());
    }

    public HawkularPipeline<S, Vertex> V(String key, Object value) {
        return this.cast(super.V(key, value));
    }

    private <I, O> HawkularPipeline<I, O> cast(GremlinPipeline<I, O> thiz) {
        return (HawkularPipeline)thiz;
    }
}

