/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.TransactionalGraph;
import com.tinkerpop.blueprints.Vertex;
import java.util.ServiceLoader;
import org.hawkular.inventory.api.Configuration;
import org.hawkular.inventory.api.Inventory;
import org.hawkular.inventory.api.Tenants;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.TenantsService;
import org.hawkular.inventory.impl.tinkerpop.spi.GraphProvider;
import org.hawkular.inventory.impl.tinkerpop.spi.IndexSpec;

public final class InventoryService
implements Inventory {
    private InventoryContext context;

    public void initialize(Configuration configuration) {
        GraphProvider gp = ServiceLoader.load(GraphProvider.class).iterator().next();
        TransactionalGraph graph = gp.instantiateGraph(configuration);
        gp.ensureIndices(graph, new IndexSpec[]{IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).withProperty(Constants.Property.__eid.name(), String.class).build(), IndexSpec.builder().withElementType(Vertex.class).withProperty(Constants.Property.__type.name(), String.class).build()});
        this.context = new InventoryContext(this, configuration.getFeedIdStrategy(), configuration.getResultFilter(), graph);
    }

    public Tenants.ReadWrite tenants() {
        return new TenantsService(this.context);
    }

    public void close() throws Exception {
        this.context.getGraph().shutdown();
    }

    public TransactionalGraph getGraph() {
        return this.context.getGraph();
    }
}

