/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.ResourceTypes;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.api.model.Version;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;
import org.hawkular.inventory.impl.tinkerpop.ResourceTypeBrowser;

final class ResourceTypesService
extends AbstractSourcedGraphService<ResourceTypes.Single, ResourceTypes.Multiple, ResourceType, ResourceType.Blueprint, ResourceType.Update>
implements ResourceTypes.ReadWrite,
ResourceTypes.Read {
    ResourceTypesService(InventoryContext context, PathContext ctx) {
        super(context, ResourceType.class, ctx);
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, ResourceType.Blueprint blueprint) {
        Vertex exampleTnt = null;
        Iterator iterator = this.source().hasType(Constants.Type.tenant).iterator();
        while (iterator.hasNext()) {
            Vertex t = (Vertex)iterator.next();
            this.addEdge(t, Relationships.WellKnown.contains.name(), newEntity);
            exampleTnt = t;
        }
        newEntity.setProperty(Constants.Property.__version.name(), (Object)new Version(blueprint.getVersion()).toString());
        return Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)ResourceTypesService.getEid(exampleTnt)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(ResourceType.class), With.id((String)ResourceTypesService.getEid(newEntity))}).get();
    }

    @Override
    protected ResourceTypes.Single createSingleBrowser(FilterApplicator.Tree path) {
        return ResourceTypeBrowser.single(this.context, path);
    }

    @Override
    protected ResourceTypes.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return ResourceTypeBrowser.multiple(this.context, path);
    }

    @Override
    protected String getProposedId(ResourceType.Blueprint b) {
        return b.getId();
    }

    @Override
    protected void updateExplicitProperties(ResourceType.Update update, Vertex vertex) {
        vertex.setProperty(Constants.Property.__version.name(), (Object)update.getVersion());
    }
}

