/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import org.hawkular.inventory.api.EntityNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.model.AbstractElement;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.paging.Page;
import org.hawkular.inventory.api.paging.PageContext;
import org.hawkular.inventory.api.paging.Pager;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;
import org.hawkular.inventory.impl.tinkerpop.RelationshipService;

abstract class AbstractBrowser<E extends Entity<B, U>, B extends Entity.Blueprint, U extends AbstractElement.Update>
extends AbstractSourcedGraphService<Void, Void, E, B, U> {
    AbstractBrowser(InventoryContext context, Class<E> entityClass, FilterApplicator.Tree path) {
        super(context, entityClass, new PathContext(path, (Filter[])null));
    }

    public E entity() {
        HawkularPipeline<?, Vertex> q = this.source();
        if (!q.hasNext()) {
            throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(this.pathContext.sourcePath));
        }
        Entity<?, ?> ret = AbstractBrowser.convert((Vertex)q.next());
        if (!this.isApplicable((AbstractElement<?, ?>)ret)) {
            throw new EntityNotFoundException(this.entityClass, FilterApplicator.filters(this.pathContext.sourcePath));
        }
        return (E)((Entity)this.entityClass.cast(ret));
    }

    public Page<E> entities(Pager pager) {
        HawkularPipeline q = this.context.getResultFilter() == null ? this.source().counter("total").page(pager).transform(v -> (Entity)this.entityClass.cast(AbstractBrowser.convert(v))) : this.source().transform(v -> (Entity)this.entityClass.cast(AbstractBrowser.convert(v))).filter(this::isApplicable).counter("total").page(pager, (e, p) -> {
            if ("id".equals(p)) {
                return e.getId();
            }
            return (Comparable)e.getProperties().get(p);
        });
        return new Page(q.toList(), (PageContext)pager, q.getCount("total"));
    }

    public RelationshipService<E, B, U> relationships() {
        return this.relationships(Relationships.Direction.outgoing);
    }

    public RelationshipService<E, B, U> relationships(Relationships.Direction direction) {
        return new RelationshipService(this.context, new PathContext(this.sourcePaths, (Filter[])null), this.entityClass, direction);
    }

    @Override
    protected final Void createSingleBrowser(FilterApplicator.Tree path) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final Void createMultiBrowser(FilterApplicator.Tree path) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final String getProposedId(Entity.Blueprint b) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }

    @Override
    protected final Filter[] initNewEntity(Vertex newEntity, Entity.Blueprint blueprint) {
        throw new IllegalStateException("This method is not valid on a browser interface.");
    }
}

