/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import java.util.Arrays;
import org.hawkular.inventory.api.model.Entity;
import org.hawkular.inventory.api.model.EntityVisitor;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Resource;
import org.hawkular.inventory.api.model.ResourceType;
import org.hawkular.inventory.api.model.Tenant;

final class Constants {
    private Constants() {
    }

    static enum Type {
        tenant(Tenant.class, new Property[0]),
        environment(Environment.class, new Property[0]),
        feed(Feed.class, new Property[0]),
        resourceType(ResourceType.class, Property.__version),
        metricType(MetricType.class, Property.__unit),
        resource(Resource.class, new Property[0]),
        metric(Metric.class, new Property[0]);

        private final String[] mappedProperties;
        private final Class<? extends Entity> entityType;

        private Type(Class<? extends Entity> entityType, Property ... mappedProperties) {
            this.entityType = entityType;
            this.mappedProperties = new String[mappedProperties.length + 2];
            Arrays.setAll(this.mappedProperties, i -> i == 0 ? Property.__type.name() : (i == 1 ? Property.__eid.name() : mappedProperties[i - 2].name()));
        }

        public static Type of(Entity<?, ?> e) {
            return (Type)((Object)e.accept((EntityVisitor)new EntityVisitor<Type, Void>(){

                public Type visitTenant(Tenant tenant, Void parameter) {
                    return Type.tenant;
                }

                public Type visitEnvironment(Environment environment, Void parameter) {
                    return Type.environment;
                }

                public Type visitFeed(Feed feed, Void parameter) {
                    return Type.feed;
                }

                public Type visitMetric(Metric metric, Void parameter) {
                    return Type.metric;
                }

                public Type visitMetricType(MetricType definition, Void parameter) {
                    return metricType;
                }

                public Type visitResource(Resource resource, Void parameter) {
                    return Type.resource;
                }

                public Type visitResourceType(ResourceType type, Void parameter) {
                    return resourceType;
                }
            }, null));
        }

        public static Type of(Class<? extends Entity> ec) {
            if (ec == Tenant.class) {
                return tenant;
            }
            if (ec == Environment.class) {
                return environment;
            }
            if (ec == Feed.class) {
                return feed;
            }
            if (ec == Metric.class) {
                return metric;
            }
            if (ec == MetricType.class) {
                return metricType;
            }
            if (ec == Resource.class) {
                return resource;
            }
            if (ec == ResourceType.class) {
                return resourceType;
            }
            throw new IllegalArgumentException("Unsupported entity class " + ec);
        }

        public Class<? extends Entity> getEntityType() {
            return this.entityType;
        }

        public String[] getMappedProperties() {
            return this.mappedProperties;
        }
    }

    static enum Property {
        __type,
        __eid,
        __version,
        __unit;


        public static String mapUserDefined(String property) {
            if ("id".equals(property)) {
                return __eid.name();
            }
            return property;
        }
    }
}

