/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import java.util.Iterator;
import org.hawkular.inventory.api.Environments;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.EnvironmentBrowser;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

final class EnvironmentsService
extends AbstractSourcedGraphService<Environments.Single, Environments.Multiple, Environment, Environment.Blueprint, Environment.Update>
implements Environments.ReadWrite,
Environments.Read {
    public EnvironmentsService(InventoryContext context, PathContext ctx) {
        super(context, Environment.class, ctx);
    }

    public void copy(String sourceEnvironmentId, String targetEnvironmentId) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, Environment.Blueprint blueprint) {
        String tenantId = null;
        Iterator iterator = this.source().hasType(Constants.Type.tenant).iterator();
        while (iterator.hasNext()) {
            Vertex sourceTenant = (Vertex)iterator.next();
            tenantId = EnvironmentsService.getEid(sourceTenant);
            this.addEdge(sourceTenant, Relationships.WellKnown.contains.name(), newEntity);
        }
        return Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)tenantId), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class), With.id((String)EnvironmentsService.getEid(newEntity))}).get();
    }

    @Override
    protected Environments.Single createSingleBrowser(FilterApplicator.Tree path) {
        return EnvironmentBrowser.single(this.context, path);
    }

    @Override
    protected Environments.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return EnvironmentBrowser.multiple(this.context, path);
    }

    @Override
    protected String getProposedId(Environment.Blueprint b) {
        return b.getId();
    }
}

