/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Iterator;
import org.hawkular.inventory.api.MetricTypes;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.MetricType;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.MetricTypeBrowser;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

final class MetricTypesService
extends AbstractSourcedGraphService<MetricTypes.Single, MetricTypes.Multiple, MetricType, MetricType.Blueprint, MetricType.Update>
implements MetricTypes.ReadWrite,
MetricTypes.ReadAssociate {
    MetricTypesService(InventoryContext context, PathContext ctx) {
        super(context, MetricType.class, ctx);
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, MetricType.Blueprint blueprint) {
        Vertex tnt = null;
        Iterator iterator = this.source().hasType(Constants.Type.tenant).iterator();
        while (iterator.hasNext()) {
            Vertex t = (Vertex)iterator.next();
            this.addEdge(t, Relationships.WellKnown.contains.name(), newEntity);
            tnt = t;
        }
        newEntity.setProperty(Constants.Property.__unit.name(), (Object)blueprint.getUnit().getDisplayName());
        return Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)MetricTypesService.getEid(tnt)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(MetricType.class), With.id((String)MetricTypesService.getEid(newEntity))}).get();
    }

    @Override
    protected MetricTypes.Single createSingleBrowser(FilterApplicator.Tree path) {
        return MetricTypeBrowser.single(this.context, path);
    }

    @Override
    protected MetricTypes.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return MetricTypeBrowser.multiple(this.context, path);
    }

    @Override
    protected String getProposedId(MetricType.Blueprint b) {
        return b.getId();
    }

    @Override
    protected void updateExplicitProperties(MetricType.Update entity, Vertex vertex) {
        vertex.setProperty(Constants.Property.__unit.name(), (Object)entity.getUnit().getDisplayName());
    }

    public Relationship associate(String id) {
        GremlinPipeline vs = this.source().in(Relationships.WellKnown.contains).out(Relationships.WellKnown.contains).hasType(Constants.Type.metricType).hasEid(id).cast(Vertex.class);
        return super.addAssociation(Constants.Type.resourceType, Relationships.WellKnown.owns, (Iterable<Vertex>)vs);
    }

    public Relationship disassociate(String id) {
        return this.removeAssociation(Constants.Type.resourceType, Relationships.WellKnown.owns, id);
    }

    public Relationship associationWith(String id) throws RelationNotFoundException {
        return this.findAssociation(id, Relationships.WellKnown.owns.name());
    }
}

