/*
 * Decompiled with CFR 0.152.
 */
package org.hawkular.inventory.impl.tinkerpop;

import com.tinkerpop.blueprints.Vertex;
import com.tinkerpop.gremlin.java.GremlinPipeline;
import java.util.Arrays;
import org.hawkular.inventory.api.Metrics;
import org.hawkular.inventory.api.RelationNotFoundException;
import org.hawkular.inventory.api.Relationships;
import org.hawkular.inventory.api.filters.Filter;
import org.hawkular.inventory.api.filters.Related;
import org.hawkular.inventory.api.filters.With;
import org.hawkular.inventory.api.model.Environment;
import org.hawkular.inventory.api.model.Feed;
import org.hawkular.inventory.api.model.Metric;
import org.hawkular.inventory.api.model.Relationship;
import org.hawkular.inventory.api.model.Tenant;
import org.hawkular.inventory.impl.tinkerpop.AbstractSourcedGraphService;
import org.hawkular.inventory.impl.tinkerpop.Constants;
import org.hawkular.inventory.impl.tinkerpop.FilterApplicator;
import org.hawkular.inventory.impl.tinkerpop.HawkularPipeline;
import org.hawkular.inventory.impl.tinkerpop.InventoryContext;
import org.hawkular.inventory.impl.tinkerpop.MetricBrowser;
import org.hawkular.inventory.impl.tinkerpop.PathContext;

final class MetricsService
extends AbstractSourcedGraphService<Metrics.Single, Metrics.Multiple, Metric, Metric.Blueprint, Metric.Update>
implements Metrics.ReadWrite,
Metrics.Read,
Metrics.ReadAssociate {
    MetricsService(InventoryContext context, PathContext ctx) {
        super(context, Metric.class, ctx);
    }

    @Override
    protected Filter[] initNewEntity(Vertex newEntity, Metric.Blueprint blueprint) {
        Vertex envVertex = null;
        HawkularPipeline<?, Vertex> envs = this.source().hasType(Constants.Type.environment);
        if (envs.hasNext()) {
            envVertex = (Vertex)envs.next();
        }
        Vertex feedVertex = null;
        HawkularPipeline<?, Vertex> fs = this.source().hasType(Constants.Type.feed);
        if (fs.hasNext()) {
            feedVertex = (Vertex)fs.next();
        }
        if (feedVertex != null && envVertex != null) {
            throw new IllegalStateException("Found both a feed and an environment as a containing entity when creating a metric under path: " + Arrays.deepToString((Object[])FilterApplicator.filters(this.sourcePaths)));
        }
        if (feedVertex == null && envVertex == null) {
            throw new IllegalArgumentException("No feed or environment found to create the metric under path: " + Arrays.deepToString((Object[])FilterApplicator.filters(this.sourcePaths)));
        }
        this.addEdge(envVertex == null ? feedVertex : envVertex, Relationships.WellKnown.contains.name(), newEntity);
        Vertex tenant = MetricsService.getTenantVertexOf(envVertex == null ? feedVertex : envVertex);
        GremlinPipeline mds = new HawkularPipeline(tenant).out(Relationships.WellKnown.contains).hasType(Constants.Type.metricType).hasEid(blueprint.getMetricTypeId()).cast(Vertex.class);
        if (!mds.hasNext()) {
            throw new IllegalArgumentException("Could not find metric type with id: " + blueprint.getMetricTypeId());
        }
        this.addEdge((Vertex)mds.next(), Relationships.WellKnown.defines.name(), newEntity);
        Filter.Accumulator f = Filter.by((Filter[])new Filter[]{With.type(Tenant.class), With.id((String)MetricsService.getEid(tenant)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Environment.class)});
        if (feedVertex == null) {
            f.and((Filter)With.id((String)MetricsService.getEid(envVertex)));
        } else {
            Vertex env = MetricsService.getEnvironmentVertexOf(feedVertex);
            f.and(new Filter[]{With.id((String)MetricsService.getEid(env)), Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Feed.class), With.id((String)MetricsService.getEid(feedVertex))});
        }
        return f.and(new Filter[]{Related.by((Relationships.WellKnown)Relationships.WellKnown.contains), With.type(Metric.class), With.id((String)MetricsService.getEid(newEntity))}).get();
    }

    @Override
    protected Metrics.Single createSingleBrowser(FilterApplicator.Tree path) {
        return MetricBrowser.single(this.context, path);
    }

    @Override
    protected String getProposedId(Metric.Blueprint b) {
        return b.getId();
    }

    @Override
    protected Metrics.Multiple createMultiBrowser(FilterApplicator.Tree path) {
        return MetricBrowser.multiple(this.context, path);
    }

    public Relationship associate(String id) {
        GremlinPipeline vs = this.source().in(Relationships.WellKnown.contains).out(Relationships.WellKnown.contains).hasType(Constants.Type.metric).hasEid(id).cast(Vertex.class);
        return super.addAssociation(Constants.Type.resource, Relationships.WellKnown.owns, (Iterable<Vertex>)vs);
    }

    public Relationship disassociate(String id) {
        return this.removeAssociation(Constants.Type.resource, Relationships.WellKnown.owns, id);
    }

    public Relationship associationWith(String id) throws RelationNotFoundException {
        return this.findAssociation(id, Relationships.WellKnown.owns.name());
    }
}

